/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingPoliciesCopier;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingPoliciesResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScalingPoliciesResponse.getter(DescribeScalingPoliciesResponse::scalingPolicies)).setter(DescribeScalingPoliciesResponse.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScalingPoliciesResponse.getter(DescribeScalingPoliciesResponse::nextToken)).setter(DescribeScalingPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScalingPolicy> scalingPolicies;
    private final String nextToken;

    private DescribeScalingPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    public List<ScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPoliciesResponse)) {
            return false;
        }
        DescribeScalingPoliciesResponse other = (DescribeScalingPoliciesResponse)((Object)obj);
        return Objects.equals(this.scalingPolicies(), other.scalingPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalingPoliciesResponse").add("ScalingPolicies", this.scalingPolicies()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeScalingPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPoliciesResponse model) {
            super(model);
            this.scalingPolicies(model.scalingPolicies);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScalingPolicy.Builder> getScalingPolicies() {
            return this.scalingPolicies != null ? (Collection)this.scalingPolicies.stream().map(ScalingPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (ScalingPolicy)((ScalingPolicy.Builder)ScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingPoliciesResponse build() {
            return new DescribeScalingPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingPoliciesResponse> {
        public Builder scalingPolicies(Collection<ScalingPolicy> var1);

        public Builder scalingPolicies(ScalingPolicy ... var1);

        public Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

