/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction;
import software.amazon.awssdk.services.applicationautoscaling.model.ScheduledActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsResponse
extends ApplicationAutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::scheduledActions)).setter(DescribeScheduledActionsResponse.setter(Builder::scheduledActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::nextToken)).setter(DescribeScheduledActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScheduledAction> scheduledActions;
    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActions = builder.scheduledActions;
        this.nextToken = builder.nextToken;
    }

    public List<ScheduledAction> scheduledActions() {
        return this.scheduledActions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        return Objects.equals(this.scheduledActions(), other.scheduledActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledActionsResponse").add("ScheduledActions", this.scheduledActions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledActions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            this.scheduledActions(model.scheduledActions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ScheduledAction.Builder> getScheduledActions() {
            return this.scheduledActions != null ? (Collection)this.scheduledActions.stream().map(ScheduledAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction ... scheduledActions) {
            this.scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder> ... scheduledActions) {
            this.scheduledActions(Stream.of(scheduledActions).map(c -> (ScheduledAction)((ScheduledAction.Builder)ScheduledAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copyFromBuilder(scheduledActions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder scheduledActions(Collection<ScheduledAction> var1);

        public Builder scheduledActions(ScheduledAction ... var1);

        public Builder scheduledActions(Consumer<ScheduledAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

