/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PolicyType;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension;
import software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace;
import software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutScalingPolicyRequest
extends ApplicationAutoScalingRequest
implements ToCopyableBuilder<Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::policyName)).setter(PutScalingPolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::serviceNamespaceAsString)).setter(PutScalingPolicyRequest.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::resourceId)).setter(PutScalingPolicyRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::scalableDimensionAsString)).setter(PutScalingPolicyRequest.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::policyTypeAsString)).setter(PutScalingPolicyRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<StepScalingPolicyConfiguration> STEP_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::stepScalingPolicyConfiguration)).setter(PutScalingPolicyRequest.setter(Builder::stepScalingPolicyConfiguration)).constructor(StepScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepScalingPolicyConfiguration").build()}).build();
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::targetTrackingScalingPolicyConfiguration)).setter(PutScalingPolicyRequest.setter(Builder::targetTrackingScalingPolicyConfiguration)).constructor(TargetTrackingScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingScalingPolicyConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, POLICY_TYPE_FIELD, STEP_SCALING_POLICY_CONFIGURATION_FIELD, TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD));
    private final String policyName;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final String policyType;
    private final StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
    private final TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.policyType = builder.policyType;
        this.stepScalingPolicyConfiguration = builder.stepScalingPolicyConfiguration;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    public String policyName() {
        return this.policyName;
    }

    public ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public String policyTypeAsString() {
        return this.policyType;
    }

    public StepScalingPolicyConfiguration stepScalingPolicyConfiguration() {
        return this.stepScalingPolicyConfiguration;
    }

    public TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepScalingPolicyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.stepScalingPolicyConfiguration(), other.stepScalingPolicyConfiguration()) && Objects.equals(this.targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"PutScalingPolicyRequest").add("PolicyName", (Object)this.policyName()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("StepScalingPolicyConfiguration", (Object)this.stepScalingPolicyConfiguration()).add("TargetTrackingScalingPolicyConfiguration", (Object)this.targetTrackingScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "StepScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stepScalingPolicyConfiguration()));
            }
            case "TargetTrackingScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingPolicyConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationAutoScalingRequest.BuilderImpl
    implements Builder {
        private String policyName;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private String policyType;
        private StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
        private TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            this.policyName(model.policyName);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.policyType(model.policyType);
            this.stepScalingPolicyConfiguration(model.stepScalingPolicyConfiguration);
            this.targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getServiceNamespaceAsString() {
            return this.serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace.toString());
            return this;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getScalableDimensionAsString() {
            return this.scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension.toString());
            return this;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        public final String getPolicyTypeAsString() {
            return this.policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType.toString());
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final StepScalingPolicyConfiguration.Builder getStepScalingPolicyConfiguration() {
            return this.stepScalingPolicyConfiguration != null ? this.stepScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
            return this;
        }

        public final void setStepScalingPolicyConfiguration(StepScalingPolicyConfiguration.BuilderImpl stepScalingPolicyConfiguration) {
            this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration != null ? stepScalingPolicyConfiguration.build() : null;
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationAutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutScalingPolicyRequest> {
        public Builder policyName(String var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder stepScalingPolicyConfiguration(StepScalingPolicyConfiguration var1);

        default public Builder stepScalingPolicyConfiguration(Consumer<StepScalingPolicyConfiguration.Builder> stepScalingPolicyConfiguration) {
            return this.stepScalingPolicyConfiguration((StepScalingPolicyConfiguration)((StepScalingPolicyConfiguration.Builder)StepScalingPolicyConfiguration.builder().applyMutation(stepScalingPolicyConfiguration)).build());
        }

        public Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfiguration var1);

        default public Builder targetTrackingScalingPolicyConfiguration(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTrackingScalingPolicyConfiguration) {
            return this.targetTrackingScalingPolicyConfiguration((TargetTrackingScalingPolicyConfiguration)((TargetTrackingScalingPolicyConfiguration.Builder)TargetTrackingScalingPolicyConfiguration.builder().applyMutation(targetTrackingScalingPolicyConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

