/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingScalingPolicyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::targetValue)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final SdkField<PredefinedMetricSpecification> PREDEFINED_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::predefinedMetricSpecification)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::predefinedMetricSpecification)).constructor(PredefinedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricSpecification").build()}).build();
    private static final SdkField<CustomizedMetricSpecification> CUSTOMIZED_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::customizedMetricSpecification)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::customizedMetricSpecification)).constructor(CustomizedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizedMetricSpecification").build()}).build();
    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::scaleOutCooldown)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::scaleOutCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()}).build();
    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::scaleInCooldown)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::scaleInCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()}).build();
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::disableScaleIn)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::disableScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD, PREDEFINED_METRIC_SPECIFICATION_FIELD, CUSTOMIZED_METRIC_SPECIFICATION_FIELD, SCALE_OUT_COOLDOWN_FIELD, SCALE_IN_COOLDOWN_FIELD, DISABLE_SCALE_IN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double targetValue;
    private final PredefinedMetricSpecification predefinedMetricSpecification;
    private final CustomizedMetricSpecification customizedMetricSpecification;
    private final Integer scaleOutCooldown;
    private final Integer scaleInCooldown;
    private final Boolean disableScaleIn;

    private TargetTrackingScalingPolicyConfiguration(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.disableScaleIn = builder.disableScaleIn;
    }

    public Double targetValue() {
        return this.targetValue;
    }

    public PredefinedMetricSpecification predefinedMetricSpecification() {
        return this.predefinedMetricSpecification;
    }

    public CustomizedMetricSpecification customizedMetricSpecification() {
        return this.customizedMetricSpecification;
    }

    public Integer scaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public Integer scaleInCooldown() {
        return this.scaleInCooldown;
    }

    public Boolean disableScaleIn() {
        return this.disableScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableScaleIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicyConfiguration)) {
            return false;
        }
        TargetTrackingScalingPolicyConfiguration other = (TargetTrackingScalingPolicyConfiguration)obj;
        return Objects.equals(this.targetValue(), other.targetValue()) && Objects.equals(this.predefinedMetricSpecification(), other.predefinedMetricSpecification()) && Objects.equals(this.customizedMetricSpecification(), other.customizedMetricSpecification()) && Objects.equals(this.scaleOutCooldown(), other.scaleOutCooldown()) && Objects.equals(this.scaleInCooldown(), other.scaleInCooldown()) && Objects.equals(this.disableScaleIn(), other.disableScaleIn());
    }

    public String toString() {
        return ToString.builder((String)"TargetTrackingScalingPolicyConfiguration").add("TargetValue", (Object)this.targetValue()).add("PredefinedMetricSpecification", (Object)this.predefinedMetricSpecification()).add("CustomizedMetricSpecification", (Object)this.customizedMetricSpecification()).add("ScaleOutCooldown", (Object)this.scaleOutCooldown()).add("ScaleInCooldown", (Object)this.scaleInCooldown()).add("DisableScaleIn", (Object)this.disableScaleIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
            case "PredefinedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricSpecification()));
            }
            case "CustomizedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.customizedMetricSpecification()));
            }
            case "ScaleOutCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleOutCooldown()));
            }
            case "ScaleInCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleInCooldown()));
            }
            case "DisableScaleIn": {
                return Optional.ofNullable(clazz.cast(this.disableScaleIn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double targetValue;
        private PredefinedMetricSpecification predefinedMetricSpecification;
        private CustomizedMetricSpecification customizedMetricSpecification;
        private Integer scaleOutCooldown;
        private Integer scaleInCooldown;
        private Boolean disableScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicyConfiguration model) {
            this.targetValue(model.targetValue);
            this.predefinedMetricSpecification(model.predefinedMetricSpecification);
            this.customizedMetricSpecification(model.customizedMetricSpecification);
            this.scaleOutCooldown(model.scaleOutCooldown);
            this.scaleInCooldown(model.scaleInCooldown);
            this.disableScaleIn(model.disableScaleIn);
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final PredefinedMetricSpecification.Builder getPredefinedMetricSpecification() {
            return this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification.BuilderImpl predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification != null ? predefinedMetricSpecification.build() : null;
        }

        public final CustomizedMetricSpecification.Builder getCustomizedMetricSpecification() {
            return this.customizedMetricSpecification != null ? this.customizedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification.BuilderImpl customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification != null ? customizedMetricSpecification.build() : null;
        }

        public final Integer getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Integer getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public final Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public TargetTrackingScalingPolicyConfiguration build() {
            return new TargetTrackingScalingPolicyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
        public Builder targetValue(Double var1);

        public Builder predefinedMetricSpecification(PredefinedMetricSpecification var1);

        default public Builder predefinedMetricSpecification(Consumer<PredefinedMetricSpecification.Builder> predefinedMetricSpecification) {
            return this.predefinedMetricSpecification((PredefinedMetricSpecification)((PredefinedMetricSpecification.Builder)PredefinedMetricSpecification.builder().applyMutation(predefinedMetricSpecification)).build());
        }

        public Builder customizedMetricSpecification(CustomizedMetricSpecification var1);

        default public Builder customizedMetricSpecification(Consumer<CustomizedMetricSpecification.Builder> customizedMetricSpecification) {
            return this.customizedMetricSpecification((CustomizedMetricSpecification)((CustomizedMetricSpecification.Builder)CustomizedMetricSpecification.builder().applyMutation(customizedMetricSpecification)).build());
        }

        public Builder scaleOutCooldown(Integer var1);

        public Builder scaleInCooldown(Integer var1);

        public Builder disableScaleIn(Boolean var1);
    }
}

