/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImportStatus {
    IMPORT_IN_PROGRESS("IMPORT_IN_PROGRESS"),
    IMPORT_COMPLETE("IMPORT_COMPLETE"),
    IMPORT_FAILED("IMPORT_FAILED"),
    IMPORT_FAILED_SERVER_LIMIT_EXCEEDED("IMPORT_FAILED_SERVER_LIMIT_EXCEEDED"),
    IMPORT_FAILED_RECORD_LIMIT_EXCEEDED("IMPORT_FAILED_RECORD_LIMIT_EXCEEDED"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_COMPLETE("DELETE_COMPLETE"),
    DELETE_FAILED("DELETE_FAILED"),
    DELETE_FAILED_LIMIT_EXCEEDED("DELETE_FAILED_LIMIT_EXCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImportStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImportStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportStatus> knownValues() {
        return Stream.of(ImportStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

