/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.Workload;
import software.amazon.awssdk.services.applicationinsights.model.WorkloadListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadsResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListWorkloadsResponse> {
    private static final SdkField<List<Workload>> WORKLOAD_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkloadList").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::workloadList)).setter(ListWorkloadsResponse.setter(Builder::workloadList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::nextToken)).setter(ListWorkloadsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Workload> workloadList;
    private final String nextToken;

    private ListWorkloadsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadList = builder.workloadList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkloadList() {
        return this.workloadList != null && !(this.workloadList instanceof SdkAutoConstructList);
    }

    public final List<Workload> workloadList() {
        return this.workloadList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadList() ? this.workloadList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadsResponse)) {
            return false;
        }
        ListWorkloadsResponse other = (ListWorkloadsResponse)((Object)obj);
        return this.hasWorkloadList() == other.hasWorkloadList() && Objects.equals(this.workloadList(), other.workloadList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadsResponse").add("WorkloadList", this.hasWorkloadList() ? this.workloadList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadList": {
                return Optional.ofNullable(clazz.cast(this.workloadList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadsResponse, T> g) {
        return obj -> g.apply((ListWorkloadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private List<Workload> workloadList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadsResponse model) {
            super(model);
            this.workloadList(model.workloadList);
            this.nextToken(model.nextToken);
        }

        public final List<Workload.Builder> getWorkloadList() {
            List<Workload.Builder> result = WorkloadListCopier.copyToBuilder(this.workloadList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadList(Collection<Workload.BuilderImpl> workloadList) {
            this.workloadList = WorkloadListCopier.copyFromBuilder(workloadList);
        }

        @Override
        public final Builder workloadList(Collection<Workload> workloadList) {
            this.workloadList = WorkloadListCopier.copy(workloadList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadList(Workload ... workloadList) {
            this.workloadList(Arrays.asList(workloadList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadList(Consumer<Workload.Builder> ... workloadList) {
            this.workloadList(Stream.of(workloadList).map(c -> (Workload)((Workload.Builder)Workload.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkloadsResponse build() {
            return new ListWorkloadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadsResponse> {
        public Builder workloadList(Collection<Workload> var1);

        public Builder workloadList(Workload ... var1);

        public Builder workloadList(Consumer<Workload.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

