/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.WorkloadConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkloadResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, DescribeWorkloadResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(DescribeWorkloadResponse.getter(DescribeWorkloadResponse::workloadId)).setter(DescribeWorkloadResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_REMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadRemarks").getter(DescribeWorkloadResponse.getter(DescribeWorkloadResponse::workloadRemarks)).setter(DescribeWorkloadResponse.setter(Builder::workloadRemarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadRemarks").build()}).build();
    private static final SdkField<WorkloadConfiguration> WORKLOAD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkloadConfiguration").getter(DescribeWorkloadResponse.getter(DescribeWorkloadResponse::workloadConfiguration)).setter(DescribeWorkloadResponse.setter(Builder::workloadConfiguration)).constructor(WorkloadConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_REMARKS_FIELD, WORKLOAD_CONFIGURATION_FIELD));
    private final String workloadId;
    private final String workloadRemarks;
    private final WorkloadConfiguration workloadConfiguration;

    private DescribeWorkloadResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadRemarks = builder.workloadRemarks;
        this.workloadConfiguration = builder.workloadConfiguration;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadRemarks() {
        return this.workloadRemarks;
    }

    public final WorkloadConfiguration workloadConfiguration() {
        return this.workloadConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadRemarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkloadResponse)) {
            return false;
        }
        DescribeWorkloadResponse other = (DescribeWorkloadResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadRemarks(), other.workloadRemarks()) && Objects.equals(this.workloadConfiguration(), other.workloadConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkloadResponse").add("WorkloadId", (Object)this.workloadId()).add("WorkloadRemarks", (Object)this.workloadRemarks()).add("WorkloadConfiguration", (Object)this.workloadConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadRemarks": {
                return Optional.ofNullable(clazz.cast(this.workloadRemarks()));
            }
            case "WorkloadConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workloadConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkloadResponse, T> g) {
        return obj -> g.apply((DescribeWorkloadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadRemarks;
        private WorkloadConfiguration workloadConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkloadResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.workloadRemarks(model.workloadRemarks);
            this.workloadConfiguration(model.workloadConfiguration);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadRemarks() {
            return this.workloadRemarks;
        }

        public final void setWorkloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
        }

        @Override
        public final Builder workloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
            return this;
        }

        public final WorkloadConfiguration.Builder getWorkloadConfiguration() {
            return this.workloadConfiguration != null ? this.workloadConfiguration.toBuilder() : null;
        }

        public final void setWorkloadConfiguration(WorkloadConfiguration.BuilderImpl workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration != null ? workloadConfiguration.build() : null;
        }

        @Override
        public final Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration;
            return this;
        }

        @Override
        public DescribeWorkloadResponse build() {
            return new DescribeWorkloadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkloadResponse> {
        public Builder workloadId(String var1);

        public Builder workloadRemarks(String var1);

        public Builder workloadConfiguration(WorkloadConfiguration var1);

        default public Builder workloadConfiguration(Consumer<WorkloadConfiguration.Builder> workloadConfiguration) {
            return this.workloadConfiguration((WorkloadConfiguration)((WorkloadConfiguration.Builder)WorkloadConfiguration.builder().applyMutation(workloadConfiguration)).build());
        }
    }
}

