/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpHeaderBlock;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.utils.async.InputStreamSubscriber;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class InputStreamAdaptingHttpStreamResponseHandler
implements HttpStreamResponseHandler {
    private final SdkHttpFullResponse.Builder responseBuilder = SdkHttpFullResponse.builder();
    private volatile InputStreamSubscriber inputStreamSubscriber;
    private final SimplePublisher<ByteBuffer> simplePublisher = new SimplePublisher();
    private final CompletableFuture<SdkHttpFullResponse> requestCompletionFuture;
    private final HttpClientConnection crtConn;

    public InputStreamAdaptingHttpStreamResponseHandler(HttpClientConnection crtConn, CompletableFuture<SdkHttpFullResponse> requestCompletionFuture) {
        this.crtConn = crtConn;
        this.requestCompletionFuture = requestCompletionFuture;
    }

    public void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, HttpHeader[] nextHeaders) {
        if (blockType == HttpHeaderBlock.MAIN.getValue()) {
            for (HttpHeader h : nextHeaders) {
                this.responseBuilder.appendHeader(h.getName(), h.getValue());
            }
        }
        this.responseBuilder.statusCode(responseStatusCode);
    }

    public int onResponseBody(HttpStream stream, byte[] bodyBytesIn) {
        CompletableFuture writeFuture;
        if (this.inputStreamSubscriber == null) {
            this.inputStreamSubscriber = new InputStreamSubscriber();
            this.simplePublisher.subscribe((Subscriber)this.inputStreamSubscriber);
            this.responseBuilder.content(AbortableInputStream.create((InputStream)this.inputStreamSubscriber));
            this.requestCompletionFuture.complete(this.responseBuilder.build());
        }
        if ((writeFuture = this.simplePublisher.send((Object)ByteBuffer.wrap(bodyBytesIn))).isDone() && !writeFuture.isCompletedExceptionally()) {
            return bodyBytesIn.length;
        }
        writeFuture.whenComplete((result, failure) -> {
            if (failure != null) {
                this.failFutureAndCloseConnection(stream, (Throwable)failure);
                return;
            }
            stream.incrementWindow(bodyBytesIn.length);
        });
        return 0;
    }

    public void onResponseComplete(HttpStream stream, int errorCode) {
        if (errorCode == 0) {
            this.onSuccessfulResponseComplete(stream);
        } else {
            this.onFailedResponseComplete(stream, errorCode);
        }
    }

    private void failFutureAndCloseConnection(HttpStream stream, Throwable failure) {
        this.requestCompletionFuture.completeExceptionally(failure);
        this.crtConn.shutdown();
        this.crtConn.close();
        stream.close();
    }

    private void onFailedResponseComplete(HttpStream stream, int errorCode) {
        Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(new HttpException(errorCode));
        this.simplePublisher.error(toThrow);
        this.failFutureAndCloseConnection(stream, toThrow);
    }

    private void onSuccessfulResponseComplete(HttpStream stream) {
        if (HttpStatusFamily.of((int)this.responseBuilder.statusCode()) == HttpStatusFamily.SERVER_ERROR) {
            this.crtConn.shutdown();
        }
        this.requestCompletionFuture.complete(this.responseBuilder.build());
        this.simplePublisher.complete();
        this.crtConn.close();
        stream.close();
    }
}

