/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.xml.internal.unmarshall;

import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.core.StringToInstant;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.query.unmarshall.XmlDomParser;
import software.amazon.awssdk.protocols.query.unmarshall.XmlElement;
import software.amazon.awssdk.protocols.query.unmarshall.XmlErrorUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.HeaderUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlPayloadUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshallerContext;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshallerRegistry;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
public final class XmlProtocolUnmarshaller
implements XmlErrorUnmarshaller {
    public static final StringToValueConverter.StringToValue<Instant> INSTANT_STRING_TO_VALUE = StringToInstant.create(XmlProtocolUnmarshaller.getDefaultTimestampFormats());
    private static final XmlUnmarshallerRegistry REGISTRY = XmlProtocolUnmarshaller.createUnmarshallerRegistry();

    private XmlProtocolUnmarshaller() {
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        XmlElement document = this.hasPayloadMembers(sdkPojo) && response.content().isPresent() ? XmlDomParser.parse((InputStream)((InputStream)response.content().get())) : null;
        return this.unmarshall(sdkPojo, document, response);
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, XmlElement resultRoot, SdkHttpFullResponse response) {
        XmlUnmarshallerContext unmarshallerContext = XmlUnmarshallerContext.builder().response(response).registry(REGISTRY).protocolUnmarshaller(this).build();
        return (TypeT)this.unmarshall(unmarshallerContext, sdkPojo, resultRoot);
    }

    SdkPojo unmarshall(XmlUnmarshallerContext context, SdkPojo sdkPojo, XmlElement root) {
        for (SdkField field : sdkPojo.sdkFields()) {
            XmlUnmarshaller<Object> unmarshaller = REGISTRY.getUnmarshaller(field.location(), field.marshallingType());
            if (root != null && field.location() == MarshallLocation.PAYLOAD) {
                List element = this.isExplicitPayloadMember(field) ? Collections.singletonList(root) : root.getElementsByName(field.unmarshallLocationName());
                if (CollectionUtils.isNullOrEmpty((Collection)element)) continue;
                Object unmarshalled = unmarshaller.unmarshall(context, element, (SdkField<Object>)field);
                field.set((Object)sdkPojo, unmarshalled);
                continue;
            }
            Object unmarshalled = unmarshaller.unmarshall(context, null, (SdkField<Object>)field);
            field.set((Object)sdkPojo, unmarshalled);
        }
        return (SdkPojo)((Buildable)sdkPojo).build();
    }

    private boolean isExplicitPayloadMember(SdkField<?> field) {
        return field.containsTrait(PayloadTrait.class);
    }

    private boolean hasPayloadMembers(SdkPojo sdkPojo) {
        return sdkPojo.sdkFields().stream().filter(f -> f.location() == MarshallLocation.PAYLOAD).findAny().isPresent();
    }

    private static Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        HashMap<MarshallLocation, TimestampFormatTrait.Format> formats = new HashMap<MarshallLocation, TimestampFormatTrait.Format>();
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.ISO_8601);
        return Collections.unmodifiableMap(formats);
    }

    private static XmlUnmarshallerRegistry createUnmarshallerRegistry() {
        return XmlUnmarshallerRegistry.builder().statusCodeUnmarshaller(MarshallingType.INTEGER, (context, content, field) -> context.response().statusCode()).headerUnmarshaller(MarshallingType.STRING, HeaderUnmarshaller.STRING).headerUnmarshaller(MarshallingType.INTEGER, HeaderUnmarshaller.INTEGER).headerUnmarshaller(MarshallingType.LONG, HeaderUnmarshaller.LONG).headerUnmarshaller(MarshallingType.DOUBLE, HeaderUnmarshaller.DOUBLE).headerUnmarshaller(MarshallingType.BOOLEAN, HeaderUnmarshaller.BOOLEAN).headerUnmarshaller(MarshallingType.INSTANT, HeaderUnmarshaller.INSTANT).headerUnmarshaller(MarshallingType.FLOAT, HeaderUnmarshaller.FLOAT).headerUnmarshaller(MarshallingType.MAP, HeaderUnmarshaller.MAP).payloadUnmarshaller(MarshallingType.STRING, XmlPayloadUnmarshaller.STRING).payloadUnmarshaller(MarshallingType.INTEGER, XmlPayloadUnmarshaller.INTEGER).payloadUnmarshaller(MarshallingType.LONG, XmlPayloadUnmarshaller.LONG).payloadUnmarshaller(MarshallingType.FLOAT, XmlPayloadUnmarshaller.FLOAT).payloadUnmarshaller(MarshallingType.DOUBLE, XmlPayloadUnmarshaller.DOUBLE).payloadUnmarshaller(MarshallingType.BIG_DECIMAL, XmlPayloadUnmarshaller.BIG_DECIMAL).payloadUnmarshaller(MarshallingType.BOOLEAN, XmlPayloadUnmarshaller.BOOLEAN).payloadUnmarshaller(MarshallingType.INSTANT, XmlPayloadUnmarshaller.INSTANT).payloadUnmarshaller(MarshallingType.SDK_BYTES, XmlPayloadUnmarshaller.SDK_BYTES).payloadUnmarshaller(MarshallingType.SDK_POJO, XmlPayloadUnmarshaller::unmarshallSdkPojo).payloadUnmarshaller(MarshallingType.LIST, XmlPayloadUnmarshaller::unmarshallList).payloadUnmarshaller(MarshallingType.MAP, XmlPayloadUnmarshaller::unmarshallMap).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Builder() {
        }

        public XmlProtocolUnmarshaller build() {
            return new XmlProtocolUnmarshaller();
        }
    }
}

