/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobErrorsCopier;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem;
import software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItemsCopier;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteEvaluationJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, BatchDeleteEvaluationJobResponse> {
    private static final SdkField<List<BatchDeleteEvaluationJobError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDeleteEvaluationJobResponse.getter(BatchDeleteEvaluationJobResponse::errors)).setter(BatchDeleteEvaluationJobResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteEvaluationJobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchDeleteEvaluationJobItem>> EVALUATION_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluationJobs").getter(BatchDeleteEvaluationJobResponse.getter(BatchDeleteEvaluationJobResponse::evaluationJobs)).setter(BatchDeleteEvaluationJobResponse.setter(Builder::evaluationJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteEvaluationJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, EVALUATION_JOBS_FIELD));
    private final List<BatchDeleteEvaluationJobError> errors;
    private final List<BatchDeleteEvaluationJobItem> evaluationJobs;

    private BatchDeleteEvaluationJobResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.evaluationJobs = builder.evaluationJobs;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteEvaluationJobError> errors() {
        return this.errors;
    }

    public final boolean hasEvaluationJobs() {
        return this.evaluationJobs != null && !(this.evaluationJobs instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteEvaluationJobItem> evaluationJobs() {
        return this.evaluationJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationJobs() ? this.evaluationJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobResponse)) {
            return false;
        }
        BatchDeleteEvaluationJobResponse other = (BatchDeleteEvaluationJobResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasEvaluationJobs() == other.hasEvaluationJobs() && Objects.equals(this.evaluationJobs(), other.evaluationJobs());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteEvaluationJobResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("EvaluationJobs", this.hasEvaluationJobs() ? this.evaluationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "evaluationJobs": {
                return Optional.ofNullable(clazz.cast(this.evaluationJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobResponse, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteEvaluationJobError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<BatchDeleteEvaluationJobItem> evaluationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobResponse model) {
            super(model);
            this.errors(model.errors);
            this.evaluationJobs(model.evaluationJobs);
        }

        public final List<BatchDeleteEvaluationJobError.Builder> getErrors() {
            List<BatchDeleteEvaluationJobError.Builder> result = BatchDeleteEvaluationJobErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteEvaluationJobError.BuilderImpl> errors) {
            this.errors = BatchDeleteEvaluationJobErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteEvaluationJobError> errors) {
            this.errors = BatchDeleteEvaluationJobErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteEvaluationJobError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteEvaluationJobError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDeleteEvaluationJobError)((BatchDeleteEvaluationJobError.Builder)BatchDeleteEvaluationJobError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchDeleteEvaluationJobItem.Builder> getEvaluationJobs() {
            List<BatchDeleteEvaluationJobItem.Builder> result = BatchDeleteEvaluationJobItemsCopier.copyToBuilder(this.evaluationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationJobs(Collection<BatchDeleteEvaluationJobItem.BuilderImpl> evaluationJobs) {
            this.evaluationJobs = BatchDeleteEvaluationJobItemsCopier.copyFromBuilder(evaluationJobs);
        }

        @Override
        public final Builder evaluationJobs(Collection<BatchDeleteEvaluationJobItem> evaluationJobs) {
            this.evaluationJobs = BatchDeleteEvaluationJobItemsCopier.copy(evaluationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationJobs(BatchDeleteEvaluationJobItem ... evaluationJobs) {
            this.evaluationJobs(Arrays.asList(evaluationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationJobs(Consumer<BatchDeleteEvaluationJobItem.Builder> ... evaluationJobs) {
            this.evaluationJobs(Stream.of(evaluationJobs).map(c -> (BatchDeleteEvaluationJobItem)((BatchDeleteEvaluationJobItem.Builder)BatchDeleteEvaluationJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobResponse build() {
            return new BatchDeleteEvaluationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteEvaluationJobResponse> {
        public Builder errors(Collection<BatchDeleteEvaluationJobError> var1);

        public Builder errors(BatchDeleteEvaluationJobError ... var1);

        public Builder errors(Consumer<BatchDeleteEvaluationJobError.Builder> ... var1);

        public Builder evaluationJobs(Collection<BatchDeleteEvaluationJobItem> var1);

        public Builder evaluationJobs(BatchDeleteEvaluationJobItem ... var1);

        public Builder evaluationJobs(Consumer<BatchDeleteEvaluationJobItem.Builder> ... var1);
    }
}

