/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelInvocationJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary;

public class ListModelInvocationJobsIterable
implements SdkIterable<ListModelInvocationJobsResponse> {
    private final BedrockClient client;
    private final ListModelInvocationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelInvocationJobsIterable(BedrockClient client, ListModelInvocationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelInvocationJobsResponseFetcher();
    }

    public Iterator<ListModelInvocationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelInvocationJobSummary> invocationJobSummaries() {
        Function<ListModelInvocationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.invocationJobSummaries() != null) {
                return response.invocationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelInvocationJobsResponseFetcher
    implements SyncPageFetcher<ListModelInvocationJobsResponse> {
        private ListModelInvocationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelInvocationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelInvocationJobsResponse nextPage(ListModelInvocationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelInvocationJobsIterable.this.client.listModelInvocationJobs(ListModelInvocationJobsIterable.this.firstRequest);
            }
            return ListModelInvocationJobsIterable.this.client.listModelInvocationJobs((ListModelInvocationJobsRequest)((Object)ListModelInvocationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

