/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicyConfig;
import software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGuardrailRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateGuardrailRequest> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::guardrailIdentifier)).setter(UpdateGuardrailRequest.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::name)).setter(UpdateGuardrailRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::description)).setter(UpdateGuardrailRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicyConfig").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::topicPolicyConfig)).setter(UpdateGuardrailRequest.setter(Builder::topicPolicyConfig)).constructor(GuardrailTopicPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()}).build();
    private static final SdkField<GuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicyConfig").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::contentPolicyConfig)).setter(UpdateGuardrailRequest.setter(Builder::contentPolicyConfig)).constructor(GuardrailContentPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build()}).build();
    private static final SdkField<GuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicyConfig").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::wordPolicyConfig)).setter(UpdateGuardrailRequest.setter(Builder::wordPolicyConfig)).constructor(GuardrailWordPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()}).build();
    private static final SdkField<GuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicyConfig").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::sensitiveInformationPolicyConfig)).setter(UpdateGuardrailRequest.setter(Builder::sensitiveInformationPolicyConfig)).constructor(GuardrailSensitiveInformationPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig").build()}).build();
    private static final SdkField<GuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicyConfig").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::contextualGroundingPolicyConfig)).setter(UpdateGuardrailRequest.setter(Builder::contextualGroundingPolicyConfig)).constructor(GuardrailContextualGroundingPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig").build()}).build();
    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedInputMessaging").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::blockedInputMessaging)).setter(UpdateGuardrailRequest.setter(Builder::blockedInputMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build()}).build();
    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedOutputsMessaging").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::blockedOutputsMessaging)).setter(UpdateGuardrailRequest.setter(Builder::blockedOutputsMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(UpdateGuardrailRequest.getter(UpdateGuardrailRequest::kmsKeyId)).setter(UpdateGuardrailRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TOPIC_POLICY_CONFIG_FIELD, CONTENT_POLICY_CONFIG_FIELD, WORD_POLICY_CONFIG_FIELD, SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, KMS_KEY_ID_FIELD));
    private final String guardrailIdentifier;
    private final String name;
    private final String description;
    private final GuardrailTopicPolicyConfig topicPolicyConfig;
    private final GuardrailContentPolicyConfig contentPolicyConfig;
    private final GuardrailWordPolicyConfig wordPolicyConfig;
    private final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
    private final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
    private final String blockedInputMessaging;
    private final String blockedOutputsMessaging;
    private final String kmsKeyId;

    private UpdateGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.wordPolicyConfig = builder.wordPolicyConfig;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final GuardrailTopicPolicyConfig topicPolicyConfig() {
        return this.topicPolicyConfig;
    }

    public final GuardrailContentPolicyConfig contentPolicyConfig() {
        return this.contentPolicyConfig;
    }

    public final GuardrailWordPolicyConfig wordPolicyConfig() {
        return this.wordPolicyConfig;
    }

    public final GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return this.sensitiveInformationPolicyConfig;
    }

    public final GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return this.contextualGroundingPolicyConfig;
    }

    public final String blockedInputMessaging() {
        return this.blockedInputMessaging;
    }

    public final String blockedOutputsMessaging() {
        return this.blockedOutputsMessaging;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGuardrailRequest)) {
            return false;
        }
        UpdateGuardrailRequest other = (UpdateGuardrailRequest)((Object)obj);
        return Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.topicPolicyConfig(), other.topicPolicyConfig()) && Objects.equals(this.contentPolicyConfig(), other.contentPolicyConfig()) && Objects.equals(this.wordPolicyConfig(), other.wordPolicyConfig()) && Objects.equals(this.sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig()) && Objects.equals(this.contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig()) && Objects.equals(this.blockedInputMessaging(), other.blockedInputMessaging()) && Objects.equals(this.blockedOutputsMessaging(), other.blockedOutputsMessaging()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGuardrailRequest").add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("TopicPolicyConfig", (Object)this.topicPolicyConfig()).add("ContentPolicyConfig", (Object)this.contentPolicyConfig()).add("WordPolicyConfig", (Object)this.wordPolicyConfig()).add("SensitiveInformationPolicyConfig", (Object)this.sensitiveInformationPolicyConfig()).add("ContextualGroundingPolicyConfig", (Object)this.contextualGroundingPolicyConfig()).add("BlockedInputMessaging", (Object)(this.blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedOutputsMessaging", (Object)(this.blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "topicPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.topicPolicyConfig()));
            }
            case "contentPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contentPolicyConfig()));
            }
            case "wordPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.wordPolicyConfig()));
            }
            case "sensitiveInformationPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicyConfig()));
            }
            case "contextualGroundingPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicyConfig()));
            }
            case "blockedInputMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedInputMessaging()));
            }
            case "blockedOutputsMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedOutputsMessaging()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGuardrailRequest, T> g) {
        return obj -> g.apply((UpdateGuardrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String guardrailIdentifier;
        private String name;
        private String description;
        private GuardrailTopicPolicyConfig topicPolicyConfig;
        private GuardrailContentPolicyConfig contentPolicyConfig;
        private GuardrailWordPolicyConfig wordPolicyConfig;
        private GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;
        private GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;
        private String blockedInputMessaging;
        private String blockedOutputsMessaging;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGuardrailRequest model) {
            super(model);
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.name(model.name);
            this.description(model.description);
            this.topicPolicyConfig(model.topicPolicyConfig);
            this.contentPolicyConfig(model.contentPolicyConfig);
            this.wordPolicyConfig(model.wordPolicyConfig);
            this.sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            this.contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            this.blockedInputMessaging(model.blockedInputMessaging);
            this.blockedOutputsMessaging(model.blockedOutputsMessaging);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return this.topicPolicyConfig != null ? this.topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(GuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(GuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final GuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return this.contentPolicyConfig != null ? this.contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(GuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(GuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final GuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return this.wordPolicyConfig != null ? this.wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(GuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(GuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return this.sensitiveInformationPolicyConfig != null ? this.sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final GuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return this.contextualGroundingPolicyConfig != null ? this.contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGuardrailRequest build() {
            return new UpdateGuardrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGuardrailRequest> {
        public Builder guardrailIdentifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder topicPolicyConfig(GuardrailTopicPolicyConfig var1);

        default public Builder topicPolicyConfig(Consumer<GuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return this.topicPolicyConfig((GuardrailTopicPolicyConfig)((GuardrailTopicPolicyConfig.Builder)GuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig)).build());
        }

        public Builder contentPolicyConfig(GuardrailContentPolicyConfig var1);

        default public Builder contentPolicyConfig(Consumer<GuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return this.contentPolicyConfig((GuardrailContentPolicyConfig)((GuardrailContentPolicyConfig.Builder)GuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig)).build());
        }

        public Builder wordPolicyConfig(GuardrailWordPolicyConfig var1);

        default public Builder wordPolicyConfig(Consumer<GuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return this.wordPolicyConfig((GuardrailWordPolicyConfig)((GuardrailWordPolicyConfig.Builder)GuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig)).build());
        }

        public Builder sensitiveInformationPolicyConfig(GuardrailSensitiveInformationPolicyConfig var1);

        default public Builder sensitiveInformationPolicyConfig(Consumer<GuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return this.sensitiveInformationPolicyConfig((GuardrailSensitiveInformationPolicyConfig)((GuardrailSensitiveInformationPolicyConfig.Builder)GuardrailSensitiveInformationPolicyConfig.builder().applyMutation(sensitiveInformationPolicyConfig)).build());
        }

        public Builder contextualGroundingPolicyConfig(GuardrailContextualGroundingPolicyConfig var1);

        default public Builder contextualGroundingPolicyConfig(Consumer<GuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return this.contextualGroundingPolicyConfig((GuardrailContextualGroundingPolicyConfig)((GuardrailContextualGroundingPolicyConfig.Builder)GuardrailContextualGroundingPolicyConfig.builder().applyMutation(contextualGroundingPolicyConfig)).build());
        }

        public Builder blockedInputMessaging(String var1);

        public Builder blockedOutputsMessaging(String var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

