/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupCostReportsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListBillingGroupCostReportsFilter> {
    private static final SdkField<List<String>> BILLING_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BillingGroupArns").getter(ListBillingGroupCostReportsFilter.getter(ListBillingGroupCostReportsFilter::billingGroupArns)).setter(ListBillingGroupCostReportsFilter.setter(Builder::billingGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BillingGroupArns", BILLING_GROUP_ARNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> billingGroupArns;

    private ListBillingGroupCostReportsFilter(BuilderImpl builder) {
        this.billingGroupArns = builder.billingGroupArns;
    }

    public final boolean hasBillingGroupArns() {
        return this.billingGroupArns != null && !(this.billingGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> billingGroupArns() {
        return this.billingGroupArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingGroupArns() ? this.billingGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupCostReportsFilter)) {
            return false;
        }
        ListBillingGroupCostReportsFilter other = (ListBillingGroupCostReportsFilter)obj;
        return this.hasBillingGroupArns() == other.hasBillingGroupArns() && Objects.equals(this.billingGroupArns(), other.billingGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingGroupCostReportsFilter").add("BillingGroupArns", this.hasBillingGroupArns() ? this.billingGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingGroupArns": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupCostReportsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupCostReportsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> billingGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupCostReportsFilter model) {
            this.billingGroupArns(model.billingGroupArns);
        }

        public final Collection<String> getBillingGroupArns() {
            if (this.billingGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.billingGroupArns;
        }

        public final void setBillingGroupArns(Collection<String> billingGroupArns) {
            this.billingGroupArns = BillingGroupArnListCopier.copy(billingGroupArns);
        }

        @Override
        public final Builder billingGroupArns(Collection<String> billingGroupArns) {
            this.billingGroupArns = BillingGroupArnListCopier.copy(billingGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupArns(String ... billingGroupArns) {
            this.billingGroupArns(Arrays.asList(billingGroupArns));
            return this;
        }

        public ListBillingGroupCostReportsFilter build() {
            return new ListBillingGroupCostReportsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupCostReportsFilter> {
        public Builder billingGroupArns(Collection<String> var1);

        public Builder billingGroupArns(String ... var1);
    }
}

