/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatus;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ComputationPreference;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupAccountGrouping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBillingGroupRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, UpdateBillingGroupRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::arn)).setter(UpdateBillingGroupRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::name)).setter(UpdateBillingGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::statusAsString)).setter(UpdateBillingGroupRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputationPreference").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::computationPreference)).setter(UpdateBillingGroupRequest.setter(Builder::computationPreference)).constructor(ComputationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::description)).setter(UpdateBillingGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<UpdateBillingGroupAccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountGrouping").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::accountGrouping)).setter(UpdateBillingGroupRequest.setter(Builder::accountGrouping)).constructor(UpdateBillingGroupAccountGrouping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, STATUS_FIELD, COMPUTATION_PREFERENCE_FIELD, DESCRIPTION_FIELD, ACCOUNT_GROUPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ComputationPreference", COMPUTATION_PREFERENCE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("AccountGrouping", ACCOUNT_GROUPING_FIELD);
        }
    });
    private final String arn;
    private final String name;
    private final String status;
    private final ComputationPreference computationPreference;
    private final String description;
    private final UpdateBillingGroupAccountGrouping accountGrouping;

    private UpdateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.computationPreference = builder.computationPreference;
        this.description = builder.description;
        this.accountGrouping = builder.accountGrouping;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ComputationPreference computationPreference() {
        return this.computationPreference;
    }

    public final String description() {
        return this.description;
    }

    public final UpdateBillingGroupAccountGrouping accountGrouping() {
        return this.accountGrouping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGrouping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupRequest)) {
            return false;
        }
        UpdateBillingGroupRequest other = (UpdateBillingGroupRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.computationPreference(), other.computationPreference()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.accountGrouping(), other.accountGrouping());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBillingGroupRequest").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("ComputationPreference", (Object)this.computationPreference()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountGrouping", (Object)this.accountGrouping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ComputationPreference": {
                return Optional.ofNullable(clazz.cast(this.computationPreference()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AccountGrouping": {
                return Optional.ofNullable(clazz.cast(this.accountGrouping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupRequest, T> g) {
        return obj -> g.apply((UpdateBillingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String status;
        private ComputationPreference computationPreference;
        private String description;
        private UpdateBillingGroupAccountGrouping accountGrouping;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.computationPreference(model.computationPreference);
            this.description(model.description);
            this.accountGrouping(model.accountGrouping);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return this.computationPreference != null ? this.computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final UpdateBillingGroupAccountGrouping.Builder getAccountGrouping() {
            return this.accountGrouping != null ? this.accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(UpdateBillingGroupAccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(UpdateBillingGroupAccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillingGroupRequest build() {
            return new UpdateBillingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBillingGroupRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(BillingGroupStatus var1);

        public Builder computationPreference(ComputationPreference var1);

        default public Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return this.computationPreference((ComputationPreference)((ComputationPreference.Builder)ComputationPreference.builder().applyMutation(computationPreference)).build());
        }

        public Builder description(String var1);

        public Builder accountGrouping(UpdateBillingGroupAccountGrouping var1);

        default public Builder accountGrouping(Consumer<UpdateBillingGroupAccountGrouping.Builder> accountGrouping) {
            return this.accountGrouping((UpdateBillingGroupAccountGrouping)((UpdateBillingGroupAccountGrouping.Builder)UpdateBillingGroupAccountGrouping.builder().applyMutation(accountGrouping)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

