/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemListElement;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;

public class ListCustomLineItemsPublisher
implements SdkPublisher<ListCustomLineItemsResponse> {
    private final BillingconductorAsyncClient client;
    private final ListCustomLineItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomLineItemsPublisher(BillingconductorAsyncClient client, ListCustomLineItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomLineItemsPublisher(BillingconductorAsyncClient client, ListCustomLineItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomLineItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomLineItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomLineItemListElement> customLineItems() {
        Function<ListCustomLineItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customLineItems() != null) {
                return response.customLineItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomLineItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomLineItemsResponseFetcher
    implements AsyncPageFetcher<ListCustomLineItemsResponse> {
        private ListCustomLineItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomLineItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomLineItemsResponse> nextPage(ListCustomLineItemsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomLineItemsPublisher.this.client.listCustomLineItems(ListCustomLineItemsPublisher.this.firstRequest);
            }
            return ListCustomLineItemsPublisher.this.client.listCustomLineItems((ListCustomLineItemsRequest)((Object)ListCustomLineItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

