/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse;

public class ListSubChannelsIterable
implements SdkIterable<ListSubChannelsResponse> {
    private final ChimeSdkMessagingClient client;
    private final ListSubChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubChannelsIterable(ChimeSdkMessagingClient client, ListSubChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubChannelsResponseFetcher();
    }

    public Iterator<ListSubChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSubChannelsResponseFetcher
    implements SyncPageFetcher<ListSubChannelsResponse> {
        private ListSubChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubChannelsResponse nextPage(ListSubChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListSubChannelsIterable.this.client.listSubChannels(ListSubChannelsIterable.this.firstRequest);
            }
            return ListSubChannelsIterable.this.client.listSubChannels((ListSubChannelsRequest)((Object)ListSubChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

