/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse;

public class ListPhoneNumbersPublisher
implements SdkPublisher<ListPhoneNumbersResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListPhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPhoneNumbersPublisher(ChimeSdkVoiceAsyncClient client, ListPhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPhoneNumbersPublisher(ChimeSdkVoiceAsyncClient client, ListPhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPhoneNumbersResponseFetcher
    implements AsyncPageFetcher<ListPhoneNumbersResponse> {
        private ListPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPhoneNumbersResponse> nextPage(ListPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersPublisher.this.client.listPhoneNumbers(ListPhoneNumbersPublisher.this.firstRequest);
            }
            return ListPhoneNumbersPublisher.this.client.listPhoneNumbers((ListPhoneNumbersRequest)((Object)ListPhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

