/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse;

public class ListPhoneNumbersIterable
implements SdkIterable<ListPhoneNumbersResponse> {
    private final ChimeSdkVoiceClient client;
    private final ListPhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumbersIterable(ChimeSdkVoiceClient client, ListPhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPhoneNumbersResponseFetcher();
    }

    public Iterator<ListPhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPhoneNumbersResponseFetcher
    implements SyncPageFetcher<ListPhoneNumbersResponse> {
        private ListPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumbersResponse nextPage(ListPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersIterable.this.client.listPhoneNumbers(ListPhoneNumbersIterable.this.firstRequest);
            }
            return ListPhoneNumbersIterable.this.client.listPhoneNumbers((ListPhoneNumbersRequest)((Object)ListPhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

