/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse;

public class ListVoiceConnectorsPublisher
implements SdkPublisher<ListVoiceConnectorsResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListVoiceConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVoiceConnectorsPublisher(ChimeSdkVoiceAsyncClient client, ListVoiceConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVoiceConnectorsPublisher(ChimeSdkVoiceAsyncClient client, ListVoiceConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVoiceConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVoiceConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVoiceConnectorsResponseFetcher
    implements AsyncPageFetcher<ListVoiceConnectorsResponse> {
        private ListVoiceConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVoiceConnectorsResponse> nextPage(ListVoiceConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceConnectorsPublisher.this.client.listVoiceConnectors(ListVoiceConnectorsPublisher.this.firstRequest);
            }
            return ListVoiceConnectorsPublisher.this.client.listVoiceConnectors((ListVoiceConnectorsRequest)((Object)ListVoiceConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

