/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetTemplateSummary;

public class ListPrivacyBudgetTemplatesPublisher
implements SdkPublisher<ListPrivacyBudgetTemplatesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListPrivacyBudgetTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrivacyBudgetTemplatesPublisher(CleanRoomsAsyncClient client, ListPrivacyBudgetTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrivacyBudgetTemplatesPublisher(CleanRoomsAsyncClient client, ListPrivacyBudgetTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrivacyBudgetTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrivacyBudgetTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrivacyBudgetTemplateSummary> privacyBudgetTemplateSummaries() {
        Function<ListPrivacyBudgetTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.privacyBudgetTemplateSummaries() != null) {
                return response.privacyBudgetTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrivacyBudgetTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrivacyBudgetTemplatesResponseFetcher
    implements AsyncPageFetcher<ListPrivacyBudgetTemplatesResponse> {
        private ListPrivacyBudgetTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivacyBudgetTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrivacyBudgetTemplatesResponse> nextPage(ListPrivacyBudgetTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListPrivacyBudgetTemplatesPublisher.this.client.listPrivacyBudgetTemplates(ListPrivacyBudgetTemplatesPublisher.this.firstRequest);
            }
            return ListPrivacyBudgetTemplatesPublisher.this.client.listPrivacyBudgetTemplates((ListPrivacyBudgetTemplatesRequest)((Object)ListPrivacyBudgetTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

