/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.IdMappingTableSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesResponse;

public class ListIdMappingTablesIterable
implements SdkIterable<ListIdMappingTablesResponse> {
    private final CleanRoomsClient client;
    private final ListIdMappingTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdMappingTablesIterable(CleanRoomsClient client, ListIdMappingTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdMappingTablesResponseFetcher();
    }

    public Iterator<ListIdMappingTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdMappingTableSummary> idMappingTableSummaries() {
        Function<ListIdMappingTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.idMappingTableSummaries() != null) {
                return response.idMappingTableSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdMappingTablesResponseFetcher
    implements SyncPageFetcher<ListIdMappingTablesResponse> {
        private ListIdMappingTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdMappingTablesResponse nextPage(ListIdMappingTablesResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingTablesIterable.this.client.listIdMappingTables(ListIdMappingTablesIterable.this.firstRequest);
            }
            return ListIdMappingTablesIterable.this.client.listIdMappingTables((ListIdMappingTablesRequest)((Object)ListIdMappingTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

