/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse;

public class ListAnalysisTemplatesPublisher
implements SdkPublisher<ListAnalysisTemplatesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListAnalysisTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalysisTemplatesPublisher(CleanRoomsAsyncClient client, ListAnalysisTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalysisTemplatesPublisher(CleanRoomsAsyncClient client, ListAnalysisTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalysisTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalysisTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisTemplateSummary> analysisTemplateSummaries() {
        Function<ListAnalysisTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisTemplateSummaries() != null) {
                return response.analysisTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnalysisTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnalysisTemplatesResponseFetcher
    implements AsyncPageFetcher<ListAnalysisTemplatesResponse> {
        private ListAnalysisTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysisTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalysisTemplatesResponse> nextPage(ListAnalysisTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysisTemplatesPublisher.this.client.listAnalysisTemplates(ListAnalysisTemplatesPublisher.this.firstRequest);
            }
            return ListAnalysisTemplatesPublisher.this.client.listAnalysisTemplates((ListAnalysisTemplatesRequest)((Object)ListAnalysisTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

