/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceConfig> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("instanceCount").getter(ResourceConfig.getter(ResourceConfig::instanceCount)).setter(ResourceConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(ResourceConfig.getter(ResourceConfig::instanceTypeAsString)).setter(ResourceConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeSizeInGB").getter(ResourceConfig.getter(ResourceConfig::volumeSizeInGB)).setter(ResourceConfig.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("instanceCount", INSTANCE_COUNT_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("volumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final String instanceType;
    private final Integer volumeSizeInGB;

    private ResourceConfig(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceConfig").add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "volumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfig, T> g) {
        return obj -> g.apply((ResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String instanceType;
        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfig model) {
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.volumeSizeInGB(model.volumeSizeInGB);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public ResourceConfig build() {
            return new ResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceConfig> {
        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder volumeSizeInGB(Integer var1);
    }
}

