/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTrainedModelExportJobRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, StartTrainedModelExportJobRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartTrainedModelExportJobRequest.getter(StartTrainedModelExportJobRequest::name)).setter(StartTrainedModelExportJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(StartTrainedModelExportJobRequest.getter(StartTrainedModelExportJobRequest::trainedModelArn)).setter(StartTrainedModelExportJobRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(StartTrainedModelExportJobRequest.getter(StartTrainedModelExportJobRequest::membershipIdentifier)).setter(StartTrainedModelExportJobRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<TrainedModelExportOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfiguration").getter(StartTrainedModelExportJobRequest.getter(StartTrainedModelExportJobRequest::outputConfiguration)).setter(StartTrainedModelExportJobRequest.setter(Builder::outputConfiguration)).constructor(TrainedModelExportOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartTrainedModelExportJobRequest.getter(StartTrainedModelExportJobRequest::description)).setter(StartTrainedModelExportJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRAINED_MODEL_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, OUTPUT_CONFIGURATION_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
        }
    });
    private final String name;
    private final String trainedModelArn;
    private final String membershipIdentifier;
    private final TrainedModelExportOutputConfiguration outputConfiguration;
    private final String description;

    private StartTrainedModelExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.trainedModelArn = builder.trainedModelArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.outputConfiguration = builder.outputConfiguration;
        this.description = builder.description;
    }

    public final String name() {
        return this.name;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final TrainedModelExportOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTrainedModelExportJobRequest)) {
            return false;
        }
        StartTrainedModelExportJobRequest other = (StartTrainedModelExportJobRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"StartTrainedModelExportJobRequest").add("Name", (Object)this.name()).add("TrainedModelArn", (Object)this.trainedModelArn()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartTrainedModelExportJobRequest, T> g) {
        return obj -> g.apply((StartTrainedModelExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String trainedModelArn;
        private String membershipIdentifier;
        private TrainedModelExportOutputConfiguration outputConfiguration;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTrainedModelExportJobRequest model) {
            super(model);
            this.name(model.name);
            this.trainedModelArn(model.trainedModelArn);
            this.membershipIdentifier(model.membershipIdentifier);
            this.outputConfiguration(model.outputConfiguration);
            this.description(model.description);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final TrainedModelExportOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(TrainedModelExportOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(TrainedModelExportOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTrainedModelExportJobRequest build() {
            return new StartTrainedModelExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTrainedModelExportJobRequest> {
        public Builder name(String var1);

        public Builder trainedModelArn(String var1);

        public Builder membershipIdentifier(String var1);

        public Builder outputConfiguration(TrainedModelExportOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<TrainedModelExportOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((TrainedModelExportOutputConfiguration)((TrainedModelExportOutputConfiguration.Builder)TrainedModelExportOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

