/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of documents that match the search request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hits implements SdkPojo, Serializable, ToCopyableBuilder<Hits.Builder, Hits> {
    private static final SdkField<Long> FOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("found")
            .getter(getter(Hits::found)).setter(setter(Builder::found))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("found").build()).build();

    private static final SdkField<Long> START_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("start")
            .getter(getter(Hits::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> CURSOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cursor")
            .getter(getter(Hits::cursor)).setter(setter(Builder::cursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cursor").build()).build();

    private static final SdkField<List<Hit>> HIT_FIELD = SdkField
            .<List<Hit>> builder(MarshallingType.LIST)
            .memberName("hit")
            .getter(getter(Hits::hit))
            .setter(setter(Builder::hit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hit").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Hit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Hit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOUND_FIELD, START_FIELD,
            CURSOR_FIELD, HIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long found;

    private final Long start;

    private final String cursor;

    private final List<Hit> hit;

    private Hits(BuilderImpl builder) {
        this.found = builder.found;
        this.start = builder.start;
        this.cursor = builder.cursor;
        this.hit = builder.hit;
    }

    /**
     * <p>
     * The total number of documents that match the search request.
     * </p>
     * 
     * @return The total number of documents that match the search request.
     */
    public final Long found() {
        return found;
    }

    /**
     * <p>
     * The index of the first matching document.
     * </p>
     * 
     * @return The index of the first matching document.
     */
    public final Long start() {
        return start;
    }

    /**
     * <p>
     * A cursor that can be used to retrieve the next set of matching documents when you want to page through a large
     * result set.
     * </p>
     * 
     * @return A cursor that can be used to retrieve the next set of matching documents when you want to page through a
     *         large result set.
     */
    public final String cursor() {
        return cursor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hit property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasHit() {
        return hit != null && !(hit instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHit} method.
     * </p>
     * 
     * @return A document that matches the search request.
     */
    public final List<Hit> hit() {
        return hit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(found());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(cursor());
        hashCode = 31 * hashCode + Objects.hashCode(hasHit() ? hit() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hits)) {
            return false;
        }
        Hits other = (Hits) obj;
        return Objects.equals(found(), other.found()) && Objects.equals(start(), other.start())
                && Objects.equals(cursor(), other.cursor()) && hasHit() == other.hasHit() && Objects.equals(hit(), other.hit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hits").add("Found", found()).add("Start", start()).add("Cursor", cursor())
                .add("Hit", hasHit() ? hit() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "found":
            return Optional.ofNullable(clazz.cast(found()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "cursor":
            return Optional.ofNullable(clazz.cast(cursor()));
        case "hit":
            return Optional.ofNullable(clazz.cast(hit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("found", FOUND_FIELD);
        map.put("start", START_FIELD);
        map.put("cursor", CURSOR_FIELD);
        map.put("hit", HIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hits, T> g) {
        return obj -> g.apply((Hits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hits> {
        /**
         * <p>
         * The total number of documents that match the search request.
         * </p>
         * 
         * @param found
         *        The total number of documents that match the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder found(Long found);

        /**
         * <p>
         * The index of the first matching document.
         * </p>
         * 
         * @param start
         *        The index of the first matching document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Long start);

        /**
         * <p>
         * A cursor that can be used to retrieve the next set of matching documents when you want to page through a
         * large result set.
         * </p>
         * 
         * @param cursor
         *        A cursor that can be used to retrieve the next set of matching documents when you want to page through
         *        a large result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cursor(String cursor);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * 
         * @param hit
         *        A document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(Collection<Hit> hit);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * 
         * @param hit
         *        A document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hit(Hit... hit);

        /**
         * <p>
         * A document that matches the search request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudsearchdomain.model.Hit.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudsearchdomain.model.Hit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudsearchdomain.model.Hit.Builder#build()} is called immediately and
         * its result is passed to {@link #hit(List<Hit>)}.
         * 
         * @param hit
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudsearchdomain.model.Hit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hit(java.util.Collection<Hit>)
         */
        Builder hit(Consumer<Hit.Builder>... hit);
    }

    static final class BuilderImpl implements Builder {
        private Long found;

        private Long start;

        private String cursor;

        private List<Hit> hit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hits model) {
            found(model.found);
            start(model.start);
            cursor(model.cursor);
            hit(model.hit);
        }

        public final Long getFound() {
            return found;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final Long getStart() {
            return start;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final String getCursor() {
            return cursor;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final List<Hit.Builder> getHit() {
            List<Hit.Builder> result = HitListCopier.copyToBuilder(this.hit);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHit(Collection<Hit.BuilderImpl> hit) {
            this.hit = HitListCopier.copyFromBuilder(hit);
        }

        @Override
        public final Builder hit(Collection<Hit> hit) {
            this.hit = HitListCopier.copy(hit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Hit... hit) {
            hit(Arrays.asList(hit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hit(Consumer<Hit.Builder>... hit) {
            hit(Stream.of(hit).map(c -> Hit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Hits build() {
            return new Hits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
