/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>Search</code> request. Contains the documents that match the specified search criteria and any
 * requested fields, highlights, and facet information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResponse extends CloudSearchDomainResponse implements
        ToCopyableBuilder<SearchResponse.Builder, SearchResponse> {
    private static final SdkField<SearchStatus> STATUS_FIELD = SdkField.<SearchStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(SearchResponse::status)).setter(setter(Builder::status))
            .constructor(SearchStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Hits> HITS_FIELD = SdkField.<Hits> builder(MarshallingType.SDK_POJO).memberName("hits")
            .getter(getter(SearchResponse::hits)).setter(setter(Builder::hits)).constructor(Hits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hits").build()).build();

    private static final SdkField<Map<String, BucketInfo>> FACETS_FIELD = SdkField
            .<Map<String, BucketInfo>> builder(MarshallingType.MAP)
            .memberName("facets")
            .getter(getter(SearchResponse::facets))
            .setter(setter(Builder::facets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("facets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BucketInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(BucketInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, FieldStats>> STATS_FIELD = SdkField
            .<Map<String, FieldStats>> builder(MarshallingType.MAP)
            .memberName("stats")
            .getter(getter(SearchResponse::stats))
            .setter(setter(Builder::stats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stats").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FieldStats> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldStats::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, HITS_FIELD,
            FACETS_FIELD, STATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SearchStatus status;

    private final Hits hits;

    private final Map<String, BucketInfo> facets;

    private final Map<String, FieldStats> stats;

    private SearchResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.hits = builder.hits;
        this.facets = builder.facets;
        this.stats = builder.stats;
    }

    /**
     * <p>
     * The status information returned for the search request.
     * </p>
     * 
     * @return The status information returned for the search request.
     */
    public final SearchStatus status() {
        return status;
    }

    /**
     * <p>
     * The documents that match the search criteria.
     * </p>
     * 
     * @return The documents that match the search criteria.
     */
    public final Hits hits() {
        return hits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Facets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFacets() {
        return facets != null && !(facets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The requested facet information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFacets} method.
     * </p>
     * 
     * @return The requested facet information.
     */
    public final Map<String, BucketInfo> facets() {
        return facets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stats property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasStats() {
        return stats != null && !(stats instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The requested field statistics information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStats} method.
     * </p>
     * 
     * @return The requested field statistics information.
     */
    public final Map<String, FieldStats> stats() {
        return stats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hits());
        hashCode = 31 * hashCode + Objects.hashCode(hasFacets() ? facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStats() ? stats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResponse)) {
            return false;
        }
        SearchResponse other = (SearchResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(hits(), other.hits())
                && hasFacets() == other.hasFacets() && Objects.equals(facets(), other.facets()) && hasStats() == other.hasStats()
                && Objects.equals(stats(), other.stats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResponse").add("Status", status()).add("Hits", hits())
                .add("Facets", hasFacets() ? facets() : null).add("Stats", hasStats() ? stats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "hits":
            return Optional.ofNullable(clazz.cast(hits()));
        case "facets":
            return Optional.ofNullable(clazz.cast(facets()));
        case "stats":
            return Optional.ofNullable(clazz.cast(stats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("hits", HITS_FIELD);
        map.put("facets", FACETS_FIELD);
        map.put("stats", STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResponse, T> g) {
        return obj -> g.apply((SearchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchResponse> {
        /**
         * <p>
         * The status information returned for the search request.
         * </p>
         * 
         * @param status
         *        The status information returned for the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SearchStatus status);

        /**
         * <p>
         * The status information returned for the search request.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchStatus.Builder} avoiding the need
         * to create one manually via {@link SearchStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SearchStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SearchStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SearchStatus)
         */
        default Builder status(Consumer<SearchStatus.Builder> status) {
            return status(SearchStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The documents that match the search criteria.
         * </p>
         * 
         * @param hits
         *        The documents that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hits(Hits hits);

        /**
         * <p>
         * The documents that match the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link Hits.Builder} avoiding the need to create
         * one manually via {@link Hits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hits.Builder#build()} is called immediately and its result is
         * passed to {@link #hits(Hits)}.
         * 
         * @param hits
         *        a consumer that will call methods on {@link Hits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hits(Hits)
         */
        default Builder hits(Consumer<Hits.Builder> hits) {
            return hits(Hits.builder().applyMutation(hits).build());
        }

        /**
         * <p>
         * The requested facet information.
         * </p>
         * 
         * @param facets
         *        The requested facet information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Map<String, BucketInfo> facets);

        /**
         * <p>
         * The requested field statistics information.
         * </p>
         * 
         * @param stats
         *        The requested field statistics information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stats(Map<String, FieldStats> stats);
    }

    static final class BuilderImpl extends CloudSearchDomainResponse.BuilderImpl implements Builder {
        private SearchStatus status;

        private Hits hits;

        private Map<String, BucketInfo> facets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, FieldStats> stats = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResponse model) {
            super(model);
            status(model.status);
            hits(model.hits);
            facets(model.facets);
            stats(model.stats);
        }

        public final SearchStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        public final Hits.Builder getHits() {
            return hits != null ? hits.toBuilder() : null;
        }

        public final void setHits(Hits.BuilderImpl hits) {
            this.hits = hits != null ? hits.build() : null;
        }

        @Override
        public final Builder hits(Hits hits) {
            this.hits = hits;
            return this;
        }

        public final Map<String, BucketInfo.Builder> getFacets() {
            Map<String, BucketInfo.Builder> result = FacetsCopier.copyToBuilder(this.facets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFacets(Map<String, BucketInfo.BuilderImpl> facets) {
            this.facets = FacetsCopier.copyFromBuilder(facets);
        }

        @Override
        public final Builder facets(Map<String, BucketInfo> facets) {
            this.facets = FacetsCopier.copy(facets);
            return this;
        }

        public final Map<String, FieldStats.Builder> getStats() {
            Map<String, FieldStats.Builder> result = StatsCopier.copyToBuilder(this.stats);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStats(Map<String, FieldStats.BuilderImpl> stats) {
            this.stats = StatsCopier.copyFromBuilder(stats);
        }

        @Override
        public final Builder stats(Map<String, FieldStats> stats) {
            this.stats = StatsCopier.copy(stats);
            return this;
        }

        @Override
        public SearchResponse build() {
            return new SearchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
