/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationCategory {
    AWS_BEST_PRACTICES("AWSBestPractices"),
    AWS_CLOUD_FORMATION_ISSUES("AWSCloudFormationIssues"),
    DUPLICATE_CODE("DuplicateCode"),
    CODE_MAINTENANCE_ISSUES("CodeMaintenanceIssues"),
    CONCURRENCY_ISSUES("ConcurrencyIssues"),
    INPUT_VALIDATIONS("InputValidations"),
    PYTHON_BEST_PRACTICES("PythonBestPractices"),
    JAVA_BEST_PRACTICES("JavaBestPractices"),
    RESOURCE_LEAKS("ResourceLeaks"),
    SECURITY_ISSUES("SecurityIssues"),
    CODE_INCONSISTENCIES("CodeInconsistencies"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationCategory> VALUE_MAP;
    private final String value;

    private RecommendationCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationCategory> knownValues() {
        EnumSet<RecommendationCategory> knownValues = EnumSet.allOf(RecommendationCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationCategory.class, RecommendationCategory::toString);
    }
}

