/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.KMSKeyDetails;
import software.amazon.awssdk.services.codegurureviewer.model.ProviderType;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociationState;
import software.amazon.awssdk.services.codegurureviewer.model.S3RepositoryDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(RepositoryAssociation.getter(RepositoryAssociation::associationId)).setter(RepositoryAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationArn").getter(RepositoryAssociation.getter(RepositoryAssociation::associationArn)).setter(RepositoryAssociation.setter(Builder::associationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationArn").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(RepositoryAssociation.getter(RepositoryAssociation::connectionArn)).setter(RepositoryAssociation.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RepositoryAssociation.getter(RepositoryAssociation::name)).setter(RepositoryAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(RepositoryAssociation.getter(RepositoryAssociation::owner)).setter(RepositoryAssociation.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(RepositoryAssociation.getter(RepositoryAssociation::providerTypeAsString)).setter(RepositoryAssociation.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RepositoryAssociation.getter(RepositoryAssociation::stateAsString)).setter(RepositoryAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(RepositoryAssociation.getter(RepositoryAssociation::stateReason)).setter(RepositoryAssociation.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimeStamp").getter(RepositoryAssociation.getter(RepositoryAssociation::lastUpdatedTimeStamp)).setter(RepositoryAssociation.setter(Builder::lastUpdatedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimeStamp").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimeStamp").getter(RepositoryAssociation.getter(RepositoryAssociation::createdTimeStamp)).setter(RepositoryAssociation.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<KMSKeyDetails> KMS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KMSKeyDetails").getter(RepositoryAssociation.getter(RepositoryAssociation::kmsKeyDetails)).setter(RepositoryAssociation.setter(Builder::kmsKeyDetails)).constructor(KMSKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyDetails").build()}).build();
    private static final SdkField<S3RepositoryDetails> S3_REPOSITORY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3RepositoryDetails").getter(RepositoryAssociation.getter(RepositoryAssociation::s3RepositoryDetails)).setter(RepositoryAssociation.setter(Builder::s3RepositoryDetails)).constructor(S3RepositoryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3RepositoryDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_ARN_FIELD, CONNECTION_ARN_FIELD, NAME_FIELD, OWNER_FIELD, PROVIDER_TYPE_FIELD, STATE_FIELD, STATE_REASON_FIELD, LAST_UPDATED_TIME_STAMP_FIELD, CREATED_TIME_STAMP_FIELD, KMS_KEY_DETAILS_FIELD, S3_REPOSITORY_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationArn;
    private final String connectionArn;
    private final String name;
    private final String owner;
    private final String providerType;
    private final String state;
    private final String stateReason;
    private final Instant lastUpdatedTimeStamp;
    private final Instant createdTimeStamp;
    private final KMSKeyDetails kmsKeyDetails;
    private final S3RepositoryDetails s3RepositoryDetails;

    private RepositoryAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationArn = builder.associationArn;
        this.connectionArn = builder.connectionArn;
        this.name = builder.name;
        this.owner = builder.owner;
        this.providerType = builder.providerType;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.kmsKeyDetails = builder.kmsKeyDetails;
        this.s3RepositoryDetails = builder.s3RepositoryDetails;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String associationArn() {
        return this.associationArn;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final RepositoryAssociationState state() {
        return RepositoryAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Instant lastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public final Instant createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final KMSKeyDetails kmsKeyDetails() {
        return this.kmsKeyDetails;
    }

    public final S3RepositoryDetails s3RepositoryDetails() {
        return this.s3RepositoryDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RepositoryDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAssociation)) {
            return false;
        }
        RepositoryAssociation other = (RepositoryAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationArn(), other.associationArn()) && Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.kmsKeyDetails(), other.kmsKeyDetails()) && Objects.equals(this.s3RepositoryDetails(), other.s3RepositoryDetails());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryAssociation").add("AssociationId", (Object)this.associationId()).add("AssociationArn", (Object)this.associationArn()).add("ConnectionArn", (Object)this.connectionArn()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("ProviderType", (Object)this.providerTypeAsString()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("LastUpdatedTimeStamp", (Object)this.lastUpdatedTimeStamp()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("KMSKeyDetails", (Object)this.kmsKeyDetails()).add("S3RepositoryDetails", (Object)this.s3RepositoryDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationArn": {
                return Optional.ofNullable(clazz.cast(this.associationArn()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "LastUpdatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimeStamp()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "KMSKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyDetails()));
            }
            case "S3RepositoryDetails": {
                return Optional.ofNullable(clazz.cast(this.s3RepositoryDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAssociation, T> g) {
        return obj -> g.apply((RepositoryAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationArn;
        private String connectionArn;
        private String name;
        private String owner;
        private String providerType;
        private String state;
        private String stateReason;
        private Instant lastUpdatedTimeStamp;
        private Instant createdTimeStamp;
        private KMSKeyDetails kmsKeyDetails;
        private S3RepositoryDetails s3RepositoryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAssociation model) {
            this.associationId(model.associationId);
            this.associationArn(model.associationArn);
            this.connectionArn(model.connectionArn);
            this.name(model.name);
            this.owner(model.owner);
            this.providerType(model.providerType);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
            this.createdTimeStamp(model.createdTimeStamp);
            this.kmsKeyDetails(model.kmsKeyDetails);
            this.s3RepositoryDetails(model.s3RepositoryDetails);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationArn() {
            return this.associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RepositoryAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getLastUpdatedTimeStamp() {
            return this.lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(Instant lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public final Instant getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Instant createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final KMSKeyDetails.Builder getKmsKeyDetails() {
            return this.kmsKeyDetails != null ? this.kmsKeyDetails.toBuilder() : null;
        }

        public final void setKmsKeyDetails(KMSKeyDetails.BuilderImpl kmsKeyDetails) {
            this.kmsKeyDetails = kmsKeyDetails != null ? kmsKeyDetails.build() : null;
        }

        @Override
        public final Builder kmsKeyDetails(KMSKeyDetails kmsKeyDetails) {
            this.kmsKeyDetails = kmsKeyDetails;
            return this;
        }

        public final S3RepositoryDetails.Builder getS3RepositoryDetails() {
            return this.s3RepositoryDetails != null ? this.s3RepositoryDetails.toBuilder() : null;
        }

        public final void setS3RepositoryDetails(S3RepositoryDetails.BuilderImpl s3RepositoryDetails) {
            this.s3RepositoryDetails = s3RepositoryDetails != null ? s3RepositoryDetails.build() : null;
        }

        @Override
        public final Builder s3RepositoryDetails(S3RepositoryDetails s3RepositoryDetails) {
            this.s3RepositoryDetails = s3RepositoryDetails;
            return this;
        }

        public RepositoryAssociation build() {
            return new RepositoryAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryAssociation> {
        public Builder associationId(String var1);

        public Builder associationArn(String var1);

        public Builder connectionArn(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder state(String var1);

        public Builder state(RepositoryAssociationState var1);

        public Builder stateReason(String var1);

        public Builder lastUpdatedTimeStamp(Instant var1);

        public Builder createdTimeStamp(Instant var1);

        public Builder kmsKeyDetails(KMSKeyDetails var1);

        default public Builder kmsKeyDetails(Consumer<KMSKeyDetails.Builder> kmsKeyDetails) {
            return this.kmsKeyDetails((KMSKeyDetails)((KMSKeyDetails.Builder)KMSKeyDetails.builder().applyMutation(kmsKeyDetails)).build());
        }

        public Builder s3RepositoryDetails(S3RepositoryDetails var1);

        default public Builder s3RepositoryDetails(Consumer<S3RepositoryDetails.Builder> s3RepositoryDetails) {
            return this.s3RepositoryDetails((S3RepositoryDetails)((S3RepositoryDetails.Builder)S3RepositoryDetails.builder().applyMutation(s3RepositoryDetails)).build());
        }
    }
}

