/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerClient;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeCodeReviewResponse;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import software.amazon.awssdk.services.codegurureviewer.model.DescribeRepositoryAssociationResponse;
import software.amazon.awssdk.services.codegurureviewer.waiters.CodeGuruReviewerWaiter;
import software.amazon.awssdk.services.codegurureviewer.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCodeGuruReviewerWaiter
implements CodeGuruReviewerWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CodeGuruReviewerClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeRepositoryAssociationResponse> repositoryAssociationSucceededWaiter;
    private final Waiter<DescribeCodeReviewResponse> codeReviewCompletedWaiter;

    private DefaultCodeGuruReviewerWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CodeGuruReviewerClient)CodeGuruReviewerClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.repositoryAssociationSucceededWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeRepositoryAssociationResponse.class).acceptors(DefaultCodeGuruReviewerWaiter.repositoryAssociationSucceededWaiterAcceptors())).overrideConfiguration(DefaultCodeGuruReviewerWaiter.repositoryAssociationSucceededWaiterConfig(builder.overrideConfiguration))).build();
        this.codeReviewCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCodeReviewResponse.class).acceptors(DefaultCodeGuruReviewerWaiter.codeReviewCompletedWaiterAcceptors())).overrideConfiguration(DefaultCodeGuruReviewerWaiter.codeReviewCompletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeCodeReviewResponse> waitUntilCodeReviewCompleted(DescribeCodeReviewRequest describeCodeReviewRequest) {
        return this.codeReviewCompletedWaiter.run(() -> this.client.describeCodeReview(this.applyWaitersUserAgent(describeCodeReviewRequest)));
    }

    @Override
    public WaiterResponse<DescribeCodeReviewResponse> waitUntilCodeReviewCompleted(DescribeCodeReviewRequest describeCodeReviewRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.codeReviewCompletedWaiter.run(() -> this.client.describeCodeReview(this.applyWaitersUserAgent(describeCodeReviewRequest)), DefaultCodeGuruReviewerWaiter.codeReviewCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeRepositoryAssociationResponse> waitUntilRepositoryAssociationSucceeded(DescribeRepositoryAssociationRequest describeRepositoryAssociationRequest) {
        return this.repositoryAssociationSucceededWaiter.run(() -> this.client.describeRepositoryAssociation(this.applyWaitersUserAgent(describeRepositoryAssociationRequest)));
    }

    @Override
    public WaiterResponse<DescribeRepositoryAssociationResponse> waitUntilRepositoryAssociationSucceeded(DescribeRepositoryAssociationRequest describeRepositoryAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.repositoryAssociationSucceededWaiter.run(() -> this.client.describeRepositoryAssociation(this.applyWaitersUserAgent(describeRepositoryAssociationRequest)), DefaultCodeGuruReviewerWaiter.repositoryAssociationSucceededWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeRepositoryAssociationResponse>> repositoryAssociationSucceededWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeRepositoryAssociationResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeRepositoryAssociationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RepositoryAssociation").field("State").value(), "Associated");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RepositoryAssociation").field("State").value(), "Failed");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("RepositoryAssociation").field("State").value(), "Associating");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCodeReviewResponse>> codeReviewCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCodeReviewResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCodeReviewResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("CodeReview").field("State").value(), "Completed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("CodeReview").field("State").value(), "Failed");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("CodeReview").field("State").value(), "Pending");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration repositoryAssociationSucceededWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration codeReviewCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CodeGuruReviewerWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CodeGuruReviewerRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeGuruReviewerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CodeGuruReviewerWaiter.Builder {
        private CodeGuruReviewerClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CodeGuruReviewerWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CodeGuruReviewerWaiter.Builder client(CodeGuruReviewerClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CodeGuruReviewerWaiter build() {
            return new DefaultCodeGuruReviewerWaiter(this);
        }
    }
}

