/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsAsyncClient;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeSummary;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse;

public class ListEventTypesPublisher
implements SdkPublisher<ListEventTypesResponse> {
    private final CodestarNotificationsAsyncClient client;
    private final ListEventTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventTypesPublisher(CodestarNotificationsAsyncClient client, ListEventTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventTypesPublisher(CodestarNotificationsAsyncClient client, ListEventTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventTypeSummary> eventTypes() {
        Function<ListEventTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTypes() != null) {
                return response.eventTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventTypesResponseFetcher
    implements AsyncPageFetcher<ListEventTypesResponse> {
        private ListEventTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventTypesResponse> nextPage(ListEventTypesResponse previousPage) {
            if (previousPage == null) {
                return ListEventTypesPublisher.this.client.listEventTypes(ListEventTypesPublisher.this.firstRequest);
            }
            return ListEventTypesPublisher.this.client.listEventTypes((ListEventTypesRequest)((Object)ListEventTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

