/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RxNorm concept that the entity could refer to, along with a score indicating the likelihood of the match.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RxNormConcept implements SdkPojo, Serializable, ToCopyableBuilder<RxNormConcept.Builder, RxNormConcept> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RxNormConcept::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(RxNormConcept::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(RxNormConcept::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, CODE_FIELD,
            SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String code;

    private final Float score;

    private RxNormConcept(BuilderImpl builder) {
        this.description = builder.description;
        this.code = builder.code;
        this.score = builder.score;
    }

    /**
     * <p>
     * The description of the RxNorm concept.
     * </p>
     * 
     * @return The description of the RxNorm concept.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * RxNorm concept ID, also known as the RxCUI.
     * </p>
     * 
     * @return RxNorm concept ID, also known as the RxCUI.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to the reported
     * RxNorm concept.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to the
     *         reported RxNorm concept.
     */
    public final Float score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RxNormConcept)) {
            return false;
        }
        RxNormConcept other = (RxNormConcept) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(code(), other.code())
                && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RxNormConcept").add("Description", description()).add("Code", code()).add("Score", score())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RxNormConcept, T> g) {
        return obj -> g.apply((RxNormConcept) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RxNormConcept> {
        /**
         * <p>
         * The description of the RxNorm concept.
         * </p>
         * 
         * @param description
         *        The description of the RxNorm concept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * RxNorm concept ID, also known as the RxCUI.
         * </p>
         * 
         * @param code
         *        RxNorm concept ID, also known as the RxCUI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to the
         * reported RxNorm concept.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend Medical has that the entity is accurately linked to the
         *        reported RxNorm concept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String code;

        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(RxNormConcept model) {
            description(model.description);
            code(model.code);
            score(model.score);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        @Override
        public RxNormConcept build() {
            return new RxNormConcept(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
