/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.RelatedItemContent;
import software.amazon.awssdk.services.connectcases.model.RelatedItemType;
import software.amazon.awssdk.services.connectcases.model.TagsCopier;
import software.amazon.awssdk.services.connectcases.model.UserUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRelatedItemsResponseItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchRelatedItemsResponseItem> {
    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("associationTime").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::associationTime)).setter(SearchRelatedItemsResponseItem.setter(Builder::associationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<RelatedItemContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::content)).setter(SearchRelatedItemsResponseItem.setter(Builder::content)).constructor(RelatedItemContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<UserUnion> PERFORMED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performedBy").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::performedBy)).setter(SearchRelatedItemsResponseItem.setter(Builder::performedBy)).constructor(UserUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()}).build();
    private static final SdkField<String> RELATED_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedItemId").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::relatedItemId)).setter(SearchRelatedItemsResponseItem.setter(Builder::relatedItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::tags)).setter(SearchRelatedItemsResponseItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SearchRelatedItemsResponseItem.getter(SearchRelatedItemsResponseItem::typeAsString)).setter(SearchRelatedItemsResponseItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_TIME_FIELD, CONTENT_FIELD, PERFORMED_BY_FIELD, RELATED_ITEM_ID_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchRelatedItemsResponseItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant associationTime;
    private final RelatedItemContent content;
    private final UserUnion performedBy;
    private final String relatedItemId;
    private final Map<String, String> tags;
    private final String type;

    private SearchRelatedItemsResponseItem(BuilderImpl builder) {
        this.associationTime = builder.associationTime;
        this.content = builder.content;
        this.performedBy = builder.performedBy;
        this.relatedItemId = builder.relatedItemId;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final Instant associationTime() {
        return this.associationTime;
    }

    public final RelatedItemContent content() {
        return this.content;
    }

    public final UserUnion performedBy() {
        return this.performedBy;
    }

    public final String relatedItemId() {
        return this.relatedItemId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final RelatedItemType type() {
        return RelatedItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.performedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRelatedItemsResponseItem)) {
            return false;
        }
        SearchRelatedItemsResponseItem other = (SearchRelatedItemsResponseItem)obj;
        return Objects.equals(this.associationTime(), other.associationTime()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.performedBy(), other.performedBy()) && Objects.equals(this.relatedItemId(), other.relatedItemId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRelatedItemsResponseItem").add("AssociationTime", (Object)this.associationTime()).add("Content", (Object)this.content()).add("PerformedBy", (Object)this.performedBy()).add("RelatedItemId", (Object)this.relatedItemId()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationTime": {
                return Optional.ofNullable(clazz.cast(this.associationTime()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "performedBy": {
                return Optional.ofNullable(clazz.cast(this.performedBy()));
            }
            case "relatedItemId": {
                return Optional.ofNullable(clazz.cast(this.relatedItemId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associationTime", ASSOCIATION_TIME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("performedBy", PERFORMED_BY_FIELD);
        map.put("relatedItemId", RELATED_ITEM_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRelatedItemsResponseItem, T> g) {
        return obj -> g.apply((SearchRelatedItemsResponseItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant associationTime;
        private RelatedItemContent content;
        private UserUnion performedBy;
        private String relatedItemId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRelatedItemsResponseItem model) {
            this.associationTime(model.associationTime);
            this.content(model.content);
            this.performedBy(model.performedBy);
            this.relatedItemId(model.relatedItemId);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final Instant getAssociationTime() {
            return this.associationTime;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        @Override
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final RelatedItemContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(RelatedItemContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RelatedItemContent content) {
            this.content = content;
            return this;
        }

        public final UserUnion.Builder getPerformedBy() {
            return this.performedBy != null ? this.performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(UserUnion.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(UserUnion performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        public final String getRelatedItemId() {
            return this.relatedItemId;
        }

        public final void setRelatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
        }

        @Override
        public final Builder relatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelatedItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SearchRelatedItemsResponseItem build() {
            return new SearchRelatedItemsResponseItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchRelatedItemsResponseItem> {
        public Builder associationTime(Instant var1);

        public Builder content(RelatedItemContent var1);

        default public Builder content(Consumer<RelatedItemContent.Builder> content) {
            return this.content((RelatedItemContent)((RelatedItemContent.Builder)RelatedItemContent.builder().applyMutation(content)).build());
        }

        public Builder performedBy(UserUnion var1);

        default public Builder performedBy(Consumer<UserUnion.Builder> performedBy) {
            return this.performedBy((UserUnion)((UserUnion.Builder)UserUnion.builder().applyMutation(performedBy)).build());
        }

        public Builder relatedItemId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(RelatedItemType var1);
    }
}

