/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.MatchingResponse;
import software.amazon.awssdk.services.customerprofiles.model.RuleBasedMatchingResponse;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, CreateDomainResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateDomainResponse.getter(CreateDomainResponse::domainName)).setter(CreateDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultExpirationDays").getter(CreateDomainResponse.getter(CreateDomainResponse::defaultExpirationDays)).setter(CreateDomainResponse.setter(Builder::defaultExpirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build()}).build();
    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultEncryptionKey").getter(CreateDomainResponse.getter(CreateDomainResponse::defaultEncryptionKey)).setter(CreateDomainResponse.setter(Builder::defaultEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build()}).build();
    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeadLetterQueueUrl").getter(CreateDomainResponse.getter(CreateDomainResponse::deadLetterQueueUrl)).setter(CreateDomainResponse.setter(Builder::deadLetterQueueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build()}).build();
    private static final SdkField<MatchingResponse> MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matching").getter(CreateDomainResponse.getter(CreateDomainResponse::matching)).setter(CreateDomainResponse.setter(Builder::matching)).constructor(MatchingResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()}).build();
    private static final SdkField<RuleBasedMatchingResponse> RULE_BASED_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleBasedMatching").getter(CreateDomainResponse.getter(CreateDomainResponse::ruleBasedMatching)).setter(CreateDomainResponse.setter(Builder::ruleBasedMatching)).constructor(RuleBasedMatchingResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleBasedMatching").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CreateDomainResponse.getter(CreateDomainResponse::createdAt)).setter(CreateDomainResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(CreateDomainResponse.getter(CreateDomainResponse::lastUpdatedAt)).setter(CreateDomainResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDomainResponse.getter(CreateDomainResponse::tags)).setter(CreateDomainResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, MATCHING_FIELD, RULE_BASED_MATCHING_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private final String domainName;
    private final Integer defaultExpirationDays;
    private final String defaultEncryptionKey;
    private final String deadLetterQueueUrl;
    private final MatchingResponse matching;
    private final RuleBasedMatchingResponse ruleBasedMatching;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private CreateDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.matching = builder.matching;
        this.ruleBasedMatching = builder.ruleBasedMatching;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer defaultExpirationDays() {
        return this.defaultExpirationDays;
    }

    public final String defaultEncryptionKey() {
        return this.defaultEncryptionKey;
    }

    public final String deadLetterQueueUrl() {
        return this.deadLetterQueueUrl;
    }

    public final MatchingResponse matching() {
        return this.matching;
    }

    public final RuleBasedMatchingResponse ruleBasedMatching() {
        return this.ruleBasedMatching;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.matching());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleBasedMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainResponse)) {
            return false;
        }
        CreateDomainResponse other = (CreateDomainResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.defaultExpirationDays(), other.defaultExpirationDays()) && Objects.equals(this.defaultEncryptionKey(), other.defaultEncryptionKey()) && Objects.equals(this.deadLetterQueueUrl(), other.deadLetterQueueUrl()) && Objects.equals(this.matching(), other.matching()) && Objects.equals(this.ruleBasedMatching(), other.ruleBasedMatching()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainResponse").add("DomainName", (Object)this.domainName()).add("DefaultExpirationDays", (Object)this.defaultExpirationDays()).add("DefaultEncryptionKey", (Object)this.defaultEncryptionKey()).add("DeadLetterQueueUrl", (Object)this.deadLetterQueueUrl()).add("Matching", (Object)this.matching()).add("RuleBasedMatching", (Object)this.ruleBasedMatching()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DefaultExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.defaultExpirationDays()));
            }
            case "DefaultEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.defaultEncryptionKey()));
            }
            case "DeadLetterQueueUrl": {
                return Optional.ofNullable(clazz.cast(this.deadLetterQueueUrl()));
            }
            case "Matching": {
                return Optional.ofNullable(clazz.cast(this.matching()));
            }
            case "RuleBasedMatching": {
                return Optional.ofNullable(clazz.cast(this.ruleBasedMatching()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainResponse, T> g) {
        return obj -> g.apply((CreateDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer defaultExpirationDays;
        private String defaultEncryptionKey;
        private String deadLetterQueueUrl;
        private MatchingResponse matching;
        private RuleBasedMatchingResponse ruleBasedMatching;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.defaultExpirationDays(model.defaultExpirationDays);
            this.defaultEncryptionKey(model.defaultEncryptionKey);
            this.deadLetterQueueUrl(model.deadLetterQueueUrl);
            this.matching(model.matching);
            this.ruleBasedMatching(model.ruleBasedMatching);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getDefaultExpirationDays() {
            return this.defaultExpirationDays;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final String getDefaultEncryptionKey() {
            return this.defaultEncryptionKey;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final String getDeadLetterQueueUrl() {
            return this.deadLetterQueueUrl;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final MatchingResponse.Builder getMatching() {
            return this.matching != null ? this.matching.toBuilder() : null;
        }

        public final void setMatching(MatchingResponse.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(MatchingResponse matching) {
            this.matching = matching;
            return this;
        }

        public final RuleBasedMatchingResponse.Builder getRuleBasedMatching() {
            return this.ruleBasedMatching != null ? this.ruleBasedMatching.toBuilder() : null;
        }

        public final void setRuleBasedMatching(RuleBasedMatchingResponse.BuilderImpl ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching != null ? ruleBasedMatching.build() : null;
        }

        @Override
        public final Builder ruleBasedMatching(RuleBasedMatchingResponse ruleBasedMatching) {
            this.ruleBasedMatching = ruleBasedMatching;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateDomainResponse build() {
            return new CreateDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainResponse> {
        public Builder domainName(String var1);

        public Builder defaultExpirationDays(Integer var1);

        public Builder defaultEncryptionKey(String var1);

        public Builder deadLetterQueueUrl(String var1);

        public Builder matching(MatchingResponse var1);

        default public Builder matching(Consumer<MatchingResponse.Builder> matching) {
            return this.matching((MatchingResponse)((MatchingResponse.Builder)MatchingResponse.builder().applyMutation(matching)).build());
        }

        public Builder ruleBasedMatching(RuleBasedMatchingResponse var1);

        default public Builder ruleBasedMatching(Consumer<RuleBasedMatchingResponse.Builder> ruleBasedMatching) {
            return this.ruleBasedMatching((RuleBasedMatchingResponse)((RuleBasedMatchingResponse.Builder)RuleBasedMatchingResponse.builder().applyMutation(ruleBasedMatching)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

