/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.Batch;
import software.amazon.awssdk.services.customerprofiles.model.BatchesCopier;
import software.amazon.awssdk.services.customerprofiles.model.FlowDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppflowIntegration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppflowIntegration> {
    private static final SdkField<FlowDefinition> FLOW_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowDefinition").getter(AppflowIntegration.getter(AppflowIntegration::flowDefinition)).setter(AppflowIntegration.setter(Builder::flowDefinition)).constructor(FlowDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinition").build()}).build();
    private static final SdkField<List<Batch>> BATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Batches").getter(AppflowIntegration.getter(AppflowIntegration::batches)).setter(AppflowIntegration.setter(Builder::batches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Batches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Batch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_FIELD, BATCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FlowDefinition", FLOW_DEFINITION_FIELD);
            this.put("Batches", BATCHES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FlowDefinition flowDefinition;
    private final List<Batch> batches;

    private AppflowIntegration(BuilderImpl builder) {
        this.flowDefinition = builder.flowDefinition;
        this.batches = builder.batches;
    }

    public final FlowDefinition flowDefinition() {
        return this.flowDefinition;
    }

    public final boolean hasBatches() {
        return this.batches != null && !(this.batches instanceof SdkAutoConstructList);
    }

    public final List<Batch> batches() {
        return this.batches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatches() ? this.batches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegration)) {
            return false;
        }
        AppflowIntegration other = (AppflowIntegration)obj;
        return Objects.equals(this.flowDefinition(), other.flowDefinition()) && this.hasBatches() == other.hasBatches() && Objects.equals(this.batches(), other.batches());
    }

    public final String toString() {
        return ToString.builder((String)"AppflowIntegration").add("FlowDefinition", (Object)(this.flowDefinition() == null ? null : "*** Sensitive Data Redacted ***")).add("Batches", this.hasBatches() ? this.batches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowDefinition": {
                return Optional.ofNullable(clazz.cast(this.flowDefinition()));
            }
            case "Batches": {
                return Optional.ofNullable(clazz.cast(this.batches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegration, T> g) {
        return obj -> g.apply((AppflowIntegration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlowDefinition flowDefinition;
        private List<Batch> batches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegration model) {
            this.flowDefinition(model.flowDefinition);
            this.batches(model.batches);
        }

        public final FlowDefinition.Builder getFlowDefinition() {
            return this.flowDefinition != null ? this.flowDefinition.toBuilder() : null;
        }

        public final void setFlowDefinition(FlowDefinition.BuilderImpl flowDefinition) {
            this.flowDefinition = flowDefinition != null ? flowDefinition.build() : null;
        }

        @Override
        public final Builder flowDefinition(FlowDefinition flowDefinition) {
            this.flowDefinition = flowDefinition;
            return this;
        }

        public final List<Batch.Builder> getBatches() {
            List<Batch.Builder> result = BatchesCopier.copyToBuilder(this.batches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatches(Collection<Batch.BuilderImpl> batches) {
            this.batches = BatchesCopier.copyFromBuilder(batches);
        }

        @Override
        public final Builder batches(Collection<Batch> batches) {
            this.batches = BatchesCopier.copy(batches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batches(Batch ... batches) {
            this.batches(Arrays.asList(batches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batches(Consumer<Batch.Builder> ... batches) {
            this.batches(Stream.of(batches).map(c -> (Batch)((Batch.Builder)Batch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AppflowIntegration build() {
            return new AppflowIntegration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppflowIntegration> {
        public Builder flowDefinition(FlowDefinition var1);

        default public Builder flowDefinition(Consumer<FlowDefinition.Builder> flowDefinition) {
            return this.flowDefinition((FlowDefinition)((FlowDefinition.Builder)FlowDefinition.builder().applyMutation(flowDefinition)).build());
        }

        public Builder batches(Collection<Batch> var1);

        public Builder batches(Batch ... var1);

        public Builder batches(Consumer<Batch.Builder> ... var1);
    }
}

