/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.DestinationSummary;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamState;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventStreamSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventStreamSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(EventStreamSummary.getter(EventStreamSummary::domainName)).setter(EventStreamSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> EVENT_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStreamName").getter(EventStreamSummary.getter(EventStreamSummary::eventStreamName)).setter(EventStreamSummary.setter(Builder::eventStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStreamName").build()}).build();
    private static final SdkField<String> EVENT_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStreamArn").getter(EventStreamSummary.getter(EventStreamSummary::eventStreamArn)).setter(EventStreamSummary.setter(Builder::eventStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStreamArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(EventStreamSummary.getter(EventStreamSummary::stateAsString)).setter(EventStreamSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> STOPPED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StoppedSince").getter(EventStreamSummary.getter(EventStreamSummary::stoppedSince)).setter(EventStreamSummary.setter(Builder::stoppedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedSince").build()}).build();
    private static final SdkField<DestinationSummary> DESTINATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSummary").getter(EventStreamSummary.getter(EventStreamSummary::destinationSummary)).setter(EventStreamSummary.setter(Builder::destinationSummary)).constructor(DestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSummary").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(EventStreamSummary.getter(EventStreamSummary::tags)).setter(EventStreamSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, EVENT_STREAM_NAME_FIELD, EVENT_STREAM_ARN_FIELD, STATE_FIELD, STOPPED_SINCE_FIELD, DESTINATION_SUMMARY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("EventStreamName", EVENT_STREAM_NAME_FIELD);
            this.put("EventStreamArn", EVENT_STREAM_ARN_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StoppedSince", STOPPED_SINCE_FIELD);
            this.put("DestinationSummary", DESTINATION_SUMMARY_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String eventStreamName;
    private final String eventStreamArn;
    private final String state;
    private final Instant stoppedSince;
    private final DestinationSummary destinationSummary;
    private final Map<String, String> tags;

    private EventStreamSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.eventStreamName = builder.eventStreamName;
        this.eventStreamArn = builder.eventStreamArn;
        this.state = builder.state;
        this.stoppedSince = builder.stoppedSince;
        this.destinationSummary = builder.destinationSummary;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String eventStreamName() {
        return this.eventStreamName;
    }

    public final String eventStreamArn() {
        return this.eventStreamArn;
    }

    public final EventStreamState state() {
        return EventStreamState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant stoppedSince() {
        return this.stoppedSince;
    }

    public final DestinationSummary destinationSummary() {
        return this.destinationSummary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStreamSummary)) {
            return false;
        }
        EventStreamSummary other = (EventStreamSummary)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.eventStreamName(), other.eventStreamName()) && Objects.equals(this.eventStreamArn(), other.eventStreamArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stoppedSince(), other.stoppedSince()) && Objects.equals(this.destinationSummary(), other.destinationSummary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EventStreamSummary").add("DomainName", (Object)this.domainName()).add("EventStreamName", (Object)this.eventStreamName()).add("EventStreamArn", (Object)this.eventStreamArn()).add("State", (Object)this.stateAsString()).add("StoppedSince", (Object)this.stoppedSince()).add("DestinationSummary", (Object)this.destinationSummary()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EventStreamName": {
                return Optional.ofNullable(clazz.cast(this.eventStreamName()));
            }
            case "EventStreamArn": {
                return Optional.ofNullable(clazz.cast(this.eventStreamArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StoppedSince": {
                return Optional.ofNullable(clazz.cast(this.stoppedSince()));
            }
            case "DestinationSummary": {
                return Optional.ofNullable(clazz.cast(this.destinationSummary()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventStreamSummary, T> g) {
        return obj -> g.apply((EventStreamSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String eventStreamName;
        private String eventStreamArn;
        private String state;
        private Instant stoppedSince;
        private DestinationSummary destinationSummary;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventStreamSummary model) {
            this.domainName(model.domainName);
            this.eventStreamName(model.eventStreamName);
            this.eventStreamArn(model.eventStreamArn);
            this.state(model.state);
            this.stoppedSince(model.stoppedSince);
            this.destinationSummary(model.destinationSummary);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEventStreamName() {
            return this.eventStreamName;
        }

        public final void setEventStreamName(String eventStreamName) {
            this.eventStreamName = eventStreamName;
        }

        @Override
        public final Builder eventStreamName(String eventStreamName) {
            this.eventStreamName = eventStreamName;
            return this;
        }

        public final String getEventStreamArn() {
            return this.eventStreamArn;
        }

        public final void setEventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
        }

        @Override
        public final Builder eventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventStreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStoppedSince() {
            return this.stoppedSince;
        }

        public final void setStoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
        }

        @Override
        public final Builder stoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
            return this;
        }

        public final DestinationSummary.Builder getDestinationSummary() {
            return this.destinationSummary != null ? this.destinationSummary.toBuilder() : null;
        }

        public final void setDestinationSummary(DestinationSummary.BuilderImpl destinationSummary) {
            this.destinationSummary = destinationSummary != null ? destinationSummary.build() : null;
        }

        @Override
        public final Builder destinationSummary(DestinationSummary destinationSummary) {
            this.destinationSummary = destinationSummary;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public EventStreamSummary build() {
            return new EventStreamSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventStreamSummary> {
        public Builder domainName(String var1);

        public Builder eventStreamName(String var1);

        public Builder eventStreamArn(String var1);

        public Builder state(String var1);

        public Builder state(EventStreamState var1);

        public Builder stoppedSince(Instant var1);

        public Builder destinationSummary(DestinationSummary var1);

        default public Builder destinationSummary(Consumer<DestinationSummary.Builder> destinationSummary) {
            return this.destinationSummary((DestinationSummary)((DestinationSummary.Builder)DestinationSummary.builder().applyMutation(destinationSummary)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

