/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.MarketoSourceProperties;
import software.amazon.awssdk.services.customerprofiles.model.S3SourceProperties;
import software.amazon.awssdk.services.customerprofiles.model.SalesforceSourceProperties;
import software.amazon.awssdk.services.customerprofiles.model.ServiceNowSourceProperties;
import software.amazon.awssdk.services.customerprofiles.model.ZendeskSourceProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConnectorProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConnectorProperties> {
    private static final SdkField<MarketoSourceProperties> MARKETO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Marketo").getter(SourceConnectorProperties.getter(SourceConnectorProperties::marketo)).setter(SourceConnectorProperties.setter(Builder::marketo)).constructor(MarketoSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()}).build();
    private static final SdkField<S3SourceProperties> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(SourceConnectorProperties.getter(SourceConnectorProperties::s3)).setter(SourceConnectorProperties.setter(Builder::s3)).constructor(S3SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<SalesforceSourceProperties> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Salesforce").getter(SourceConnectorProperties.getter(SourceConnectorProperties::salesforce)).setter(SourceConnectorProperties.setter(Builder::salesforce)).constructor(SalesforceSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<ServiceNowSourceProperties> SERVICE_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceNow").getter(SourceConnectorProperties.getter(SourceConnectorProperties::serviceNow)).setter(SourceConnectorProperties.setter(Builder::serviceNow)).constructor(ServiceNowSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()}).build();
    private static final SdkField<ZendeskSourceProperties> ZENDESK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Zendesk").getter(SourceConnectorProperties.getter(SourceConnectorProperties::zendesk)).setter(SourceConnectorProperties.setter(Builder::zendesk)).constructor(ZendeskSourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKETO_FIELD, S3_FIELD, SALESFORCE_FIELD, SERVICE_NOW_FIELD, ZENDESK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Marketo", MARKETO_FIELD);
            this.put("S3", S3_FIELD);
            this.put("Salesforce", SALESFORCE_FIELD);
            this.put("ServiceNow", SERVICE_NOW_FIELD);
            this.put("Zendesk", ZENDESK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final MarketoSourceProperties marketo;
    private final S3SourceProperties s3;
    private final SalesforceSourceProperties salesforce;
    private final ServiceNowSourceProperties serviceNow;
    private final ZendeskSourceProperties zendesk;

    private SourceConnectorProperties(BuilderImpl builder) {
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.zendesk = builder.zendesk;
    }

    public final MarketoSourceProperties marketo() {
        return this.marketo;
    }

    public final S3SourceProperties s3() {
        return this.s3;
    }

    public final SalesforceSourceProperties salesforce() {
        return this.salesforce;
    }

    public final ServiceNowSourceProperties serviceNow() {
        return this.serviceNow;
    }

    public final ZendeskSourceProperties zendesk() {
        return this.zendesk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketo());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(this.zendesk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectorProperties)) {
            return false;
        }
        SourceConnectorProperties other = (SourceConnectorProperties)obj;
        return Objects.equals(this.marketo(), other.marketo()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.serviceNow(), other.serviceNow()) && Objects.equals(this.zendesk(), other.zendesk());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConnectorProperties").add("Marketo", (Object)this.marketo()).add("S3", (Object)this.s3()).add("Salesforce", (Object)this.salesforce()).add("ServiceNow", (Object)this.serviceNow()).add("Zendesk", (Object)this.zendesk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marketo": {
                return Optional.ofNullable(clazz.cast(this.marketo()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "ServiceNow": {
                return Optional.ofNullable(clazz.cast(this.serviceNow()));
            }
            case "Zendesk": {
                return Optional.ofNullable(clazz.cast(this.zendesk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectorProperties, T> g) {
        return obj -> g.apply((SourceConnectorProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MarketoSourceProperties marketo;
        private S3SourceProperties s3;
        private SalesforceSourceProperties salesforce;
        private ServiceNowSourceProperties serviceNow;
        private ZendeskSourceProperties zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectorProperties model) {
            this.marketo(model.marketo);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.serviceNow(model.serviceNow);
            this.zendesk(model.zendesk);
        }

        public final MarketoSourceProperties.Builder getMarketo() {
            return this.marketo != null ? this.marketo.toBuilder() : null;
        }

        public final void setMarketo(MarketoSourceProperties.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        @Override
        public final Builder marketo(MarketoSourceProperties marketo) {
            this.marketo = marketo;
            return this;
        }

        public final S3SourceProperties.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3SourceProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3SourceProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final SalesforceSourceProperties.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceSourceProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceSourceProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final ServiceNowSourceProperties.Builder getServiceNow() {
            return this.serviceNow != null ? this.serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowSourceProperties.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowSourceProperties serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final ZendeskSourceProperties.Builder getZendesk() {
            return this.zendesk != null ? this.zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskSourceProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public final Builder zendesk(ZendeskSourceProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public SourceConnectorProperties build() {
            return new SourceConnectorProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConnectorProperties> {
        public Builder marketo(MarketoSourceProperties var1);

        default public Builder marketo(Consumer<MarketoSourceProperties.Builder> marketo) {
            return this.marketo((MarketoSourceProperties)((MarketoSourceProperties.Builder)MarketoSourceProperties.builder().applyMutation(marketo)).build());
        }

        public Builder s3(S3SourceProperties var1);

        default public Builder s3(Consumer<S3SourceProperties.Builder> s3) {
            return this.s3((S3SourceProperties)((S3SourceProperties.Builder)S3SourceProperties.builder().applyMutation(s3)).build());
        }

        public Builder salesforce(SalesforceSourceProperties var1);

        default public Builder salesforce(Consumer<SalesforceSourceProperties.Builder> salesforce) {
            return this.salesforce((SalesforceSourceProperties)((SalesforceSourceProperties.Builder)SalesforceSourceProperties.builder().applyMutation(salesforce)).build());
        }

        public Builder serviceNow(ServiceNowSourceProperties var1);

        default public Builder serviceNow(Consumer<ServiceNowSourceProperties.Builder> serviceNow) {
            return this.serviceNow((ServiceNowSourceProperties)((ServiceNowSourceProperties.Builder)ServiceNowSourceProperties.builder().applyMutation(serviceNow)).build());
        }

        public Builder zendesk(ZendeskSourceProperties var1);

        default public Builder zendesk(Consumer<ZendeskSourceProperties.Builder> zendesk) {
            return this.zendesk((ZendeskSourceProperties)((ZendeskSourceProperties.Builder)ZendeskSourceProperties.builder().applyMutation(zendesk)).build());
        }
    }
}

