/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.DataPullMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledTriggerProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledTriggerProperties> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleExpression)).setter(ScheduledTriggerProperties.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<String> DATA_PULL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataPullMode").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::dataPullModeAsString)).setter(ScheduledTriggerProperties.setter(Builder::dataPullMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPullMode").build()}).build();
    private static final SdkField<Instant> SCHEDULE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduleStartTime").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleStartTime)).setter(ScheduledTriggerProperties.setter(Builder::scheduleStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleStartTime").build()}).build();
    private static final SdkField<Instant> SCHEDULE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduleEndTime").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleEndTime)).setter(ScheduledTriggerProperties.setter(Builder::scheduleEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleEndTime").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::timezone)).setter(ScheduledTriggerProperties.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Long> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScheduleOffset").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::scheduleOffset)).setter(ScheduledTriggerProperties.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<Instant> FIRST_EXECUTION_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FirstExecutionFrom").getter(ScheduledTriggerProperties.getter(ScheduledTriggerProperties::firstExecutionFrom)).setter(ScheduledTriggerProperties.setter(Builder::firstExecutionFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstExecutionFrom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, DATA_PULL_MODE_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD, TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, FIRST_EXECUTION_FROM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledTriggerProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final String dataPullMode;
    private final Instant scheduleStartTime;
    private final Instant scheduleEndTime;
    private final String timezone;
    private final Long scheduleOffset;
    private final Instant firstExecutionFrom;

    private ScheduledTriggerProperties(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.dataPullMode = builder.dataPullMode;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.timezone = builder.timezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.firstExecutionFrom = builder.firstExecutionFrom;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final DataPullMode dataPullMode() {
        return DataPullMode.fromValue(this.dataPullMode);
    }

    public final String dataPullModeAsString() {
        return this.dataPullMode;
    }

    public final Instant scheduleStartTime() {
        return this.scheduleStartTime;
    }

    public final Instant scheduleEndTime() {
        return this.scheduleEndTime;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final Long scheduleOffset() {
        return this.scheduleOffset;
    }

    public final Instant firstExecutionFrom() {
        return this.firstExecutionFrom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPullModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstExecutionFrom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledTriggerProperties)) {
            return false;
        }
        ScheduledTriggerProperties other = (ScheduledTriggerProperties)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.dataPullModeAsString(), other.dataPullModeAsString()) && Objects.equals(this.scheduleStartTime(), other.scheduleStartTime()) && Objects.equals(this.scheduleEndTime(), other.scheduleEndTime()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.firstExecutionFrom(), other.firstExecutionFrom());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledTriggerProperties").add("ScheduleExpression", (Object)this.scheduleExpression()).add("DataPullMode", (Object)this.dataPullModeAsString()).add("ScheduleStartTime", (Object)this.scheduleStartTime()).add("ScheduleEndTime", (Object)this.scheduleEndTime()).add("Timezone", (Object)this.timezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("FirstExecutionFrom", (Object)this.firstExecutionFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "DataPullMode": {
                return Optional.ofNullable(clazz.cast(this.dataPullModeAsString()));
            }
            case "ScheduleStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleStartTime()));
            }
            case "ScheduleEndTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleEndTime()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "FirstExecutionFrom": {
                return Optional.ofNullable(clazz.cast(this.firstExecutionFrom()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("DataPullMode", DATA_PULL_MODE_FIELD);
        map.put("ScheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("ScheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
        map.put("FirstExecutionFrom", FIRST_EXECUTION_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledTriggerProperties, T> g) {
        return obj -> g.apply((ScheduledTriggerProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String dataPullMode;
        private Instant scheduleStartTime;
        private Instant scheduleEndTime;
        private String timezone;
        private Long scheduleOffset;
        private Instant firstExecutionFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledTriggerProperties model) {
            this.scheduleExpression(model.scheduleExpression);
            this.dataPullMode(model.dataPullMode);
            this.scheduleStartTime(model.scheduleStartTime);
            this.scheduleEndTime(model.scheduleEndTime);
            this.timezone(model.timezone);
            this.scheduleOffset(model.scheduleOffset);
            this.firstExecutionFrom(model.firstExecutionFrom);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getDataPullMode() {
            return this.dataPullMode;
        }

        public final void setDataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
        }

        @Override
        public final Builder dataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
            return this;
        }

        @Override
        public final Builder dataPullMode(DataPullMode dataPullMode) {
            this.dataPullMode(dataPullMode == null ? null : dataPullMode.toString());
            return this;
        }

        public final Instant getScheduleStartTime() {
            return this.scheduleStartTime;
        }

        public final void setScheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Instant getScheduleEndTime() {
            return this.scheduleEndTime;
        }

        public final void setScheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Instant getFirstExecutionFrom() {
            return this.firstExecutionFrom;
        }

        public final void setFirstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
        }

        @Override
        public final Builder firstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
            return this;
        }

        public ScheduledTriggerProperties build() {
            return new ScheduledTriggerProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledTriggerProperties> {
        public Builder scheduleExpression(String var1);

        public Builder dataPullMode(String var1);

        public Builder dataPullMode(DataPullMode var1);

        public Builder scheduleStartTime(Instant var1);

        public Builder scheduleEndTime(Instant var1);

        public Builder timezone(String var1);

        public Builder scheduleOffset(Long var1);

        public Builder firstExecutionFrom(Instant var1);
    }
}

