/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerCondition;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerConditionsCopier;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerLimits;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventTriggerResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, UpdateEventTriggerResponse> {
    private static final SdkField<String> EVENT_TRIGGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventTriggerName").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::eventTriggerName)).setter(UpdateEventTriggerResponse.setter(Builder::eventTriggerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerName").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::objectTypeName)).setter(UpdateEventTriggerResponse.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::description)).setter(UpdateEventTriggerResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EventTriggerCondition>> EVENT_TRIGGER_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTriggerConditions").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::eventTriggerConditions)).setter(UpdateEventTriggerResponse.setter(Builder::eventTriggerConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTriggerCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEGMENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentFilter").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::segmentFilter)).setter(UpdateEventTriggerResponse.setter(Builder::segmentFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentFilter").build()}).build();
    private static final SdkField<EventTriggerLimits> EVENT_TRIGGER_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventTriggerLimits").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::eventTriggerLimits)).setter(UpdateEventTriggerResponse.setter(Builder::eventTriggerLimits)).constructor(EventTriggerLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerLimits").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::createdAt)).setter(UpdateEventTriggerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::lastUpdatedAt)).setter(UpdateEventTriggerResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateEventTriggerResponse.getter(UpdateEventTriggerResponse::tags)).setter(UpdateEventTriggerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRIGGER_NAME_FIELD, OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, EVENT_TRIGGER_CONDITIONS_FIELD, SEGMENT_FILTER_FIELD, EVENT_TRIGGER_LIMITS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEventTriggerResponse.memberNameToFieldInitializer();
    private final String eventTriggerName;
    private final String objectTypeName;
    private final String description;
    private final List<EventTriggerCondition> eventTriggerConditions;
    private final String segmentFilter;
    private final EventTriggerLimits eventTriggerLimits;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private UpdateEventTriggerResponse(BuilderImpl builder) {
        super(builder);
        this.eventTriggerName = builder.eventTriggerName;
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.eventTriggerConditions = builder.eventTriggerConditions;
        this.segmentFilter = builder.segmentFilter;
        this.eventTriggerLimits = builder.eventTriggerLimits;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String eventTriggerName() {
        return this.eventTriggerName;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventTriggerConditions() {
        return this.eventTriggerConditions != null && !(this.eventTriggerConditions instanceof SdkAutoConstructList);
    }

    public final List<EventTriggerCondition> eventTriggerConditions() {
        return this.eventTriggerConditions;
    }

    public final String segmentFilter() {
        return this.segmentFilter;
    }

    public final EventTriggerLimits eventTriggerLimits() {
        return this.eventTriggerLimits;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTriggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTriggerConditions() ? this.eventTriggerConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTriggerLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventTriggerResponse)) {
            return false;
        }
        UpdateEventTriggerResponse other = (UpdateEventTriggerResponse)((Object)obj);
        return Objects.equals(this.eventTriggerName(), other.eventTriggerName()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.description(), other.description()) && this.hasEventTriggerConditions() == other.hasEventTriggerConditions() && Objects.equals(this.eventTriggerConditions(), other.eventTriggerConditions()) && Objects.equals(this.segmentFilter(), other.segmentFilter()) && Objects.equals(this.eventTriggerLimits(), other.eventTriggerLimits()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventTriggerResponse").add("EventTriggerName", (Object)this.eventTriggerName()).add("ObjectTypeName", (Object)this.objectTypeName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EventTriggerConditions", (Object)(this.eventTriggerConditions() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentFilter", (Object)this.segmentFilter()).add("EventTriggerLimits", (Object)this.eventTriggerLimits()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventTriggerName": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerName()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventTriggerConditions": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerConditions()));
            }
            case "SegmentFilter": {
                return Optional.ofNullable(clazz.cast(this.segmentFilter()));
            }
            case "EventTriggerLimits": {
                return Optional.ofNullable(clazz.cast(this.eventTriggerLimits()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventTriggerName", EVENT_TRIGGER_NAME_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EventTriggerConditions", EVENT_TRIGGER_CONDITIONS_FIELD);
        map.put("SegmentFilter", SEGMENT_FILTER_FIELD);
        map.put("EventTriggerLimits", EVENT_TRIGGER_LIMITS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventTriggerResponse, T> g) {
        return obj -> g.apply((UpdateEventTriggerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String eventTriggerName;
        private String objectTypeName;
        private String description;
        private List<EventTriggerCondition> eventTriggerConditions = DefaultSdkAutoConstructList.getInstance();
        private String segmentFilter;
        private EventTriggerLimits eventTriggerLimits;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventTriggerResponse model) {
            super(model);
            this.eventTriggerName(model.eventTriggerName);
            this.objectTypeName(model.objectTypeName);
            this.description(model.description);
            this.eventTriggerConditions(model.eventTriggerConditions);
            this.segmentFilter(model.segmentFilter);
            this.eventTriggerLimits(model.eventTriggerLimits);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getEventTriggerName() {
            return this.eventTriggerName;
        }

        public final void setEventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
        }

        @Override
        public final Builder eventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventTriggerCondition.Builder> getEventTriggerConditions() {
            List<EventTriggerCondition.Builder> result = EventTriggerConditionsCopier.copyToBuilder(this.eventTriggerConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggerConditions(Collection<EventTriggerCondition.BuilderImpl> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copyFromBuilder(eventTriggerConditions);
        }

        @Override
        public final Builder eventTriggerConditions(Collection<EventTriggerCondition> eventTriggerConditions) {
            this.eventTriggerConditions = EventTriggerConditionsCopier.copy(eventTriggerConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(EventTriggerCondition ... eventTriggerConditions) {
            this.eventTriggerConditions(Arrays.asList(eventTriggerConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder> ... eventTriggerConditions) {
            this.eventTriggerConditions(Stream.of(eventTriggerConditions).map(c -> (EventTriggerCondition)((EventTriggerCondition.Builder)EventTriggerCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSegmentFilter() {
            return this.segmentFilter;
        }

        public final void setSegmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
        }

        @Override
        public final Builder segmentFilter(String segmentFilter) {
            this.segmentFilter = segmentFilter;
            return this;
        }

        public final EventTriggerLimits.Builder getEventTriggerLimits() {
            return this.eventTriggerLimits != null ? this.eventTriggerLimits.toBuilder() : null;
        }

        public final void setEventTriggerLimits(EventTriggerLimits.BuilderImpl eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits != null ? eventTriggerLimits.build() : null;
        }

        @Override
        public final Builder eventTriggerLimits(EventTriggerLimits eventTriggerLimits) {
            this.eventTriggerLimits = eventTriggerLimits;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateEventTriggerResponse build() {
            return new UpdateEventTriggerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventTriggerResponse> {
        public Builder eventTriggerName(String var1);

        public Builder objectTypeName(String var1);

        public Builder description(String var1);

        public Builder eventTriggerConditions(Collection<EventTriggerCondition> var1);

        public Builder eventTriggerConditions(EventTriggerCondition ... var1);

        public Builder eventTriggerConditions(Consumer<EventTriggerCondition.Builder> ... var1);

        public Builder segmentFilter(String var1);

        public Builder eventTriggerLimits(EventTriggerLimits var1);

        default public Builder eventTriggerLimits(Consumer<EventTriggerLimits.Builder> eventTriggerLimits) {
            return this.eventTriggerLimits((EventTriggerLimits)((EventTriggerLimits.Builder)EventTriggerLimits.builder().applyMutation(eventTriggerLimits)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

