/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributeItem;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListObjectTypeAttributesResponse;

public class ListObjectTypeAttributesPublisher
implements SdkPublisher<ListObjectTypeAttributesResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListObjectTypeAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectTypeAttributesPublisher(CustomerProfilesAsyncClient client, ListObjectTypeAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectTypeAttributesPublisher(CustomerProfilesAsyncClient client, ListObjectTypeAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectTypeAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectTypeAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListObjectTypeAttributeItem> items() {
        Function<ListObjectTypeAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListObjectTypeAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListObjectTypeAttributesResponseFetcher
    implements AsyncPageFetcher<ListObjectTypeAttributesResponse> {
        private ListObjectTypeAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectTypeAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectTypeAttributesResponse> nextPage(ListObjectTypeAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectTypeAttributesPublisher.this.client.listObjectTypeAttributes(ListObjectTypeAttributesPublisher.this.firstRequest);
            }
            return ListObjectTypeAttributesPublisher.this.client.listObjectTypeAttributes((ListObjectTypeAttributesRequest)((Object)ListObjectTypeAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

