/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.ComputeConfig;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationConfigRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyReplicationConfigRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigArn").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::replicationConfigArn)).setter(ModifyReplicationConfigRequest.setter(Builder::replicationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build()}).build();
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigIdentifier").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::replicationConfigIdentifier)).setter(ModifyReplicationConfigRequest.setter(Builder::replicationConfigIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationType").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::replicationTypeAsString)).setter(ModifyReplicationConfigRequest.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableMappings").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::tableMappings)).setter(ModifyReplicationConfigRequest.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSettings").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::replicationSettings)).setter(ModifyReplicationConfigRequest.setter(Builder::replicationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build()}).build();
    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplementalSettings").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::supplementalSettings)).setter(ModifyReplicationConfigRequest.setter(Builder::supplementalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build()}).build();
    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeConfig").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::computeConfig)).setter(ModifyReplicationConfigRequest.setter(Builder::computeConfig)).constructor(ComputeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndpointArn").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::sourceEndpointArn)).setter(ModifyReplicationConfigRequest.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEndpointArn").getter(ModifyReplicationConfigRequest.getter(ModifyReplicationConfigRequest::targetEndpointArn)).setter(ModifyReplicationConfigRequest.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD, REPLICATION_CONFIG_IDENTIFIER_FIELD, REPLICATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_SETTINGS_FIELD, SUPPLEMENTAL_SETTINGS_FIELD, COMPUTE_CONFIG_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD));
    private final String replicationConfigArn;
    private final String replicationConfigIdentifier;
    private final String replicationType;
    private final String tableMappings;
    private final String replicationSettings;
    private final String supplementalSettings;
    private final ComputeConfig computeConfig;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;

    private ModifyReplicationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.replicationType = builder.replicationType;
        this.tableMappings = builder.tableMappings;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.computeConfig = builder.computeConfig;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
    }

    public final String replicationConfigArn() {
        return this.replicationConfigArn;
    }

    public final String replicationConfigIdentifier() {
        return this.replicationConfigIdentifier;
    }

    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final String tableMappings() {
        return this.tableMappings;
    }

    public final String replicationSettings() {
        return this.replicationSettings;
    }

    public final String supplementalSettings() {
        return this.supplementalSettings;
    }

    public final ComputeConfig computeConfig() {
        return this.computeConfig;
    }

    public final String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public final String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationConfigRequest)) {
            return false;
        }
        ModifyReplicationConfigRequest other = (ModifyReplicationConfigRequest)((Object)obj);
        return Objects.equals(this.replicationConfigArn(), other.replicationConfigArn()) && Objects.equals(this.replicationConfigIdentifier(), other.replicationConfigIdentifier()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationSettings(), other.replicationSettings()) && Objects.equals(this.supplementalSettings(), other.supplementalSettings()) && Objects.equals(this.computeConfig(), other.computeConfig()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyReplicationConfigRequest").add("ReplicationConfigArn", (Object)this.replicationConfigArn()).add("ReplicationConfigIdentifier", (Object)this.replicationConfigIdentifier()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationSettings", (Object)this.replicationSettings()).add("SupplementalSettings", (Object)this.supplementalSettings()).add("ComputeConfig", (Object)this.computeConfig()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigArn()));
            }
            case "ReplicationConfigIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigIdentifier()));
            }
            case "ReplicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationSettings()));
            }
            case "SupplementalSettings": {
                return Optional.ofNullable(clazz.cast(this.supplementalSettings()));
            }
            case "ComputeConfig": {
                return Optional.ofNullable(clazz.cast(this.computeConfig()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationConfigRequest, T> g) {
        return obj -> g.apply((ModifyReplicationConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationConfigArn;
        private String replicationConfigIdentifier;
        private String replicationType;
        private String tableMappings;
        private String replicationSettings;
        private String supplementalSettings;
        private ComputeConfig computeConfig;
        private String sourceEndpointArn;
        private String targetEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationConfigRequest model) {
            super(model);
            this.replicationConfigArn(model.replicationConfigArn);
            this.replicationConfigIdentifier(model.replicationConfigIdentifier);
            this.replicationType(model.replicationType);
            this.tableMappings(model.tableMappings);
            this.replicationSettings(model.replicationSettings);
            this.supplementalSettings(model.supplementalSettings);
            this.computeConfig(model.computeConfig);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
        }

        public final String getReplicationConfigArn() {
            return this.replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getReplicationConfigIdentifier() {
            return this.replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationSettings() {
            return this.replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return this.supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return this.computeConfig != null ? this.computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationConfigRequest build() {
            return new ModifyReplicationConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReplicationConfigRequest> {
        public Builder replicationConfigArn(String var1);

        public Builder replicationConfigIdentifier(String var1);

        public Builder replicationType(String var1);

        public Builder replicationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationSettings(String var1);

        public Builder supplementalSettings(String var1);

        public Builder computeConfig(ComputeConfig var1);

        default public Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return this.computeConfig((ComputeConfig)((ComputeConfig.Builder)ComputeConfig.builder().applyMutation(computeConfig)).build());
        }

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

