/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSetting;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDataMigrationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationIdentifier").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::dataMigrationIdentifier)).setter(ModifyDataMigrationRequest.setter(Builder::dataMigrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationIdentifier").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationName").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::dataMigrationName)).setter(ModifyDataMigrationRequest.setter(Builder::dataMigrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationName").build()}).build();
    private static final SdkField<Boolean> ENABLE_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCloudwatchLogs").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::enableCloudwatchLogs)).setter(ModifyDataMigrationRequest.setter(Builder::enableCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogs").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::serviceAccessRoleArn)).setter(ModifyDataMigrationRequest.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationType").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::dataMigrationTypeAsString)).setter(ModifyDataMigrationRequest.setter(Builder::dataMigrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationType").build()}).build();
    private static final SdkField<List<SourceDataSetting>> SOURCE_DATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDataSettings").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::sourceDataSettings)).setter(ModifyDataMigrationRequest.setter(Builder::sourceDataSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDataSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfJobs").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::numberOfJobs)).setter(ModifyDataMigrationRequest.setter(Builder::numberOfJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(ModifyDataMigrationRequest.getter(ModifyDataMigrationRequest::selectionRules)).setter(ModifyDataMigrationRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_IDENTIFIER_FIELD, DATA_MIGRATION_NAME_FIELD, ENABLE_CLOUDWATCH_LOGS_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, DATA_MIGRATION_TYPE_FIELD, SOURCE_DATA_SETTINGS_FIELD, NUMBER_OF_JOBS_FIELD, SELECTION_RULES_FIELD));
    private final String dataMigrationIdentifier;
    private final String dataMigrationName;
    private final Boolean enableCloudwatchLogs;
    private final String serviceAccessRoleArn;
    private final String dataMigrationType;
    private final List<SourceDataSetting> sourceDataSettings;
    private final Integer numberOfJobs;
    private final String selectionRules;

    private ModifyDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationIdentifier = builder.dataMigrationIdentifier;
        this.dataMigrationName = builder.dataMigrationName;
        this.enableCloudwatchLogs = builder.enableCloudwatchLogs;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.dataMigrationType = builder.dataMigrationType;
        this.sourceDataSettings = builder.sourceDataSettings;
        this.numberOfJobs = builder.numberOfJobs;
        this.selectionRules = builder.selectionRules;
    }

    public final String dataMigrationIdentifier() {
        return this.dataMigrationIdentifier;
    }

    public final String dataMigrationName() {
        return this.dataMigrationName;
    }

    public final Boolean enableCloudwatchLogs() {
        return this.enableCloudwatchLogs;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final MigrationTypeValue dataMigrationType() {
        return MigrationTypeValue.fromValue(this.dataMigrationType);
    }

    public final String dataMigrationTypeAsString() {
        return this.dataMigrationType;
    }

    public final boolean hasSourceDataSettings() {
        return this.sourceDataSettings != null && !(this.sourceDataSettings instanceof SdkAutoConstructList);
    }

    public final List<SourceDataSetting> sourceDataSettings() {
        return this.sourceDataSettings;
    }

    public final Integer numberOfJobs() {
        return this.numberOfJobs;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataSettings() ? this.sourceDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDataMigrationRequest)) {
            return false;
        }
        ModifyDataMigrationRequest other = (ModifyDataMigrationRequest)((Object)obj);
        return Objects.equals(this.dataMigrationIdentifier(), other.dataMigrationIdentifier()) && Objects.equals(this.dataMigrationName(), other.dataMigrationName()) && Objects.equals(this.enableCloudwatchLogs(), other.enableCloudwatchLogs()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.dataMigrationTypeAsString(), other.dataMigrationTypeAsString()) && this.hasSourceDataSettings() == other.hasSourceDataSettings() && Objects.equals(this.sourceDataSettings(), other.sourceDataSettings()) && Objects.equals(this.numberOfJobs(), other.numberOfJobs()) && Objects.equals(this.selectionRules(), other.selectionRules());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDataMigrationRequest").add("DataMigrationIdentifier", (Object)this.dataMigrationIdentifier()).add("DataMigrationName", (Object)this.dataMigrationName()).add("EnableCloudwatchLogs", (Object)this.enableCloudwatchLogs()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("DataMigrationType", (Object)this.dataMigrationTypeAsString()).add("SourceDataSettings", this.hasSourceDataSettings() ? this.sourceDataSettings() : null).add("NumberOfJobs", (Object)this.numberOfJobs()).add("SelectionRules", (Object)(this.selectionRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataMigrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationIdentifier()));
            }
            case "DataMigrationName": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationName()));
            }
            case "EnableCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogs()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "DataMigrationType": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationTypeAsString()));
            }
            case "SourceDataSettings": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSettings()));
            }
            case "NumberOfJobs": {
                return Optional.ofNullable(clazz.cast(this.numberOfJobs()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDataMigrationRequest, T> g) {
        return obj -> g.apply((ModifyDataMigrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String dataMigrationIdentifier;
        private String dataMigrationName;
        private Boolean enableCloudwatchLogs;
        private String serviceAccessRoleArn;
        private String dataMigrationType;
        private List<SourceDataSetting> sourceDataSettings = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfJobs;
        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDataMigrationRequest model) {
            super(model);
            this.dataMigrationIdentifier(model.dataMigrationIdentifier);
            this.dataMigrationName(model.dataMigrationName);
            this.enableCloudwatchLogs(model.enableCloudwatchLogs);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.dataMigrationType(model.dataMigrationType);
            this.sourceDataSettings(model.sourceDataSettings);
            this.numberOfJobs(model.numberOfJobs);
            this.selectionRules(model.selectionRules);
        }

        public final String getDataMigrationIdentifier() {
            return this.dataMigrationIdentifier;
        }

        public final void setDataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
        }

        @Override
        public final Builder dataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
            return this;
        }

        public final String getDataMigrationName() {
            return this.dataMigrationName;
        }

        public final void setDataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
        }

        @Override
        public final Builder dataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        public final Boolean getEnableCloudwatchLogs() {
            return this.enableCloudwatchLogs;
        }

        public final void setEnableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
        }

        @Override
        public final Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getDataMigrationType() {
            return this.dataMigrationType;
        }

        public final void setDataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
        }

        @Override
        public final Builder dataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        @Override
        public final Builder dataMigrationType(MigrationTypeValue dataMigrationType) {
            this.dataMigrationType(dataMigrationType == null ? null : dataMigrationType.toString());
            return this;
        }

        public final List<SourceDataSetting.Builder> getSourceDataSettings() {
            List<SourceDataSetting.Builder> result = SourceDataSettingsCopier.copyToBuilder(this.sourceDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSettings(Collection<SourceDataSetting.BuilderImpl> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copyFromBuilder(sourceDataSettings);
        }

        @Override
        public final Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copy(sourceDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(SourceDataSetting ... sourceDataSettings) {
            this.sourceDataSettings(Arrays.asList(sourceDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... sourceDataSettings) {
            this.sourceDataSettings(Stream.of(sourceDataSettings).map(c -> (SourceDataSetting)((SourceDataSetting.Builder)SourceDataSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfJobs() {
            return this.numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDataMigrationRequest build() {
            return new ModifyDataMigrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDataMigrationRequest> {
        public Builder dataMigrationIdentifier(String var1);

        public Builder dataMigrationName(String var1);

        public Builder enableCloudwatchLogs(Boolean var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder dataMigrationType(String var1);

        public Builder dataMigrationType(MigrationTypeValue var1);

        public Builder sourceDataSettings(Collection<SourceDataSetting> var1);

        public Builder sourceDataSettings(SourceDataSetting ... var1);

        public Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... var1);

        public Builder numberOfJobs(Integer var1);

        public Builder selectionRules(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

