/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstancePrivateIpAddressListCopier;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstancePublicIpAddressListCopier;
import software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup;
import software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationInstance> {
    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceIdentifier").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstanceIdentifier)).setter(ReplicationInstance.setter(Builder::replicationInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceClass").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstanceClass)).setter(ReplicationInstance.setter(Builder::replicationInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceStatus").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstanceStatus)).setter(ReplicationInstance.setter(Builder::replicationInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceStatus").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(ReplicationInstance.getter(ReplicationInstance::allocatedStorage)).setter(ReplicationInstance.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InstanceCreateTime").getter(ReplicationInstance.getter(ReplicationInstance::instanceCreateTime)).setter(ReplicationInstance.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(ReplicationInstance.getter(ReplicationInstance::vpcSecurityGroups)).setter(ReplicationInstance.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReplicationInstance.getter(ReplicationInstance::availabilityZone)).setter(ReplicationInstance.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<ReplicationSubnetGroup> REPLICATION_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationSubnetGroup").getter(ReplicationInstance.getter(ReplicationInstance::replicationSubnetGroup)).setter(ReplicationInstance.setter(Builder::replicationSubnetGroup)).constructor(ReplicationSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroup").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ReplicationInstance.getter(ReplicationInstance::preferredMaintenanceWindow)).setter(ReplicationInstance.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<ReplicationPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(ReplicationInstance.getter(ReplicationInstance::pendingModifiedValues)).setter(ReplicationInstance.setter(Builder::pendingModifiedValues)).constructor(ReplicationPendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(ReplicationInstance.getter(ReplicationInstance::multiAZ)).setter(ReplicationInstance.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ReplicationInstance.getter(ReplicationInstance::engineVersion)).setter(ReplicationInstance.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(ReplicationInstance.getter(ReplicationInstance::autoMinorVersionUpgrade)).setter(ReplicationInstance.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ReplicationInstance.getter(ReplicationInstance::kmsKeyId)).setter(ReplicationInstance.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceArn").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstanceArn)).setter(ReplicationInstance.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstancePublicIpAddress").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstancePublicIpAddress)).setter(ReplicationInstance.setter(Builder::replicationInstancePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstancePublicIpAddress").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstancePrivateIpAddress").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstancePrivateIpAddress)).setter(ReplicationInstance.setter(Builder::replicationInstancePrivateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstancePrivateIpAddress").build()}).build();
    private static final SdkField<List<String>> REPLICATION_INSTANCE_PUBLIC_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInstancePublicIpAddresses").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstancePublicIpAddresses)).setter(ReplicationInstance.setter(Builder::replicationInstancePublicIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstancePublicIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPLICATION_INSTANCE_PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInstancePrivateIpAddresses").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstancePrivateIpAddresses)).setter(ReplicationInstance.setter(Builder::replicationInstancePrivateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstancePrivateIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPLICATION_INSTANCE_IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInstanceIpv6Addresses").getter(ReplicationInstance.getter(ReplicationInstance::replicationInstanceIpv6Addresses)).setter(ReplicationInstance.setter(Builder::replicationInstanceIpv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIpv6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(ReplicationInstance.getter(ReplicationInstance::publiclyAccessible)).setter(ReplicationInstance.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryAvailabilityZone").getter(ReplicationInstance.getter(ReplicationInstance::secondaryAvailabilityZone)).setter(ReplicationInstance.setter(Builder::secondaryAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAvailabilityZone").build()}).build();
    private static final SdkField<Instant> FREE_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FreeUntil").getter(ReplicationInstance.getter(ReplicationInstance::freeUntil)).setter(ReplicationInstance.setter(Builder::freeUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeUntil").build()}).build();
    private static final SdkField<String> DNS_NAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsNameServers").getter(ReplicationInstance.getter(ReplicationInstance::dnsNameServers)).setter(ReplicationInstance.setter(Builder::dnsNameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsNameServers").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(ReplicationInstance.getter(ReplicationInstance::networkType)).setter(ReplicationInstance.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_IDENTIFIER_FIELD, REPLICATION_INSTANCE_CLASS_FIELD, REPLICATION_INSTANCE_STATUS_FIELD, ALLOCATED_STORAGE_FIELD, INSTANCE_CREATE_TIME_FIELD, VPC_SECURITY_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD, REPLICATION_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, KMS_KEY_ID_FIELD, REPLICATION_INSTANCE_ARN_FIELD, REPLICATION_INSTANCE_PUBLIC_IP_ADDRESS_FIELD, REPLICATION_INSTANCE_PRIVATE_IP_ADDRESS_FIELD, REPLICATION_INSTANCE_PUBLIC_IP_ADDRESSES_FIELD, REPLICATION_INSTANCE_PRIVATE_IP_ADDRESSES_FIELD, REPLICATION_INSTANCE_IPV6_ADDRESSES_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD, FREE_UNTIL_FIELD, DNS_NAME_SERVERS_FIELD, NETWORK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationInstanceIdentifier", REPLICATION_INSTANCE_IDENTIFIER_FIELD);
            this.put("ReplicationInstanceClass", REPLICATION_INSTANCE_CLASS_FIELD);
            this.put("ReplicationInstanceStatus", REPLICATION_INSTANCE_STATUS_FIELD);
            this.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
            this.put("InstanceCreateTime", INSTANCE_CREATE_TIME_FIELD);
            this.put("VpcSecurityGroups", VPC_SECURITY_GROUPS_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("ReplicationSubnetGroup", REPLICATION_SUBNET_GROUP_FIELD);
            this.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
            this.put("PendingModifiedValues", PENDING_MODIFIED_VALUES_FIELD);
            this.put("MultiAZ", MULTI_AZ_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("ReplicationInstanceArn", REPLICATION_INSTANCE_ARN_FIELD);
            this.put("ReplicationInstancePublicIpAddress", REPLICATION_INSTANCE_PUBLIC_IP_ADDRESS_FIELD);
            this.put("ReplicationInstancePrivateIpAddress", REPLICATION_INSTANCE_PRIVATE_IP_ADDRESS_FIELD);
            this.put("ReplicationInstancePublicIpAddresses", REPLICATION_INSTANCE_PUBLIC_IP_ADDRESSES_FIELD);
            this.put("ReplicationInstancePrivateIpAddresses", REPLICATION_INSTANCE_PRIVATE_IP_ADDRESSES_FIELD);
            this.put("ReplicationInstanceIpv6Addresses", REPLICATION_INSTANCE_IPV6_ADDRESSES_FIELD);
            this.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
            this.put("SecondaryAvailabilityZone", SECONDARY_AVAILABILITY_ZONE_FIELD);
            this.put("FreeUntil", FREE_UNTIL_FIELD);
            this.put("DnsNameServers", DNS_NAME_SERVERS_FIELD);
            this.put("NetworkType", NETWORK_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicationInstanceIdentifier;
    private final String replicationInstanceClass;
    private final String replicationInstanceStatus;
    private final Integer allocatedStorage;
    private final Instant instanceCreateTime;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String availabilityZone;
    private final ReplicationSubnetGroup replicationSubnetGroup;
    private final String preferredMaintenanceWindow;
    private final ReplicationPendingModifiedValues pendingModifiedValues;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final String kmsKeyId;
    private final String replicationInstanceArn;
    private final String replicationInstancePublicIpAddress;
    private final String replicationInstancePrivateIpAddress;
    private final List<String> replicationInstancePublicIpAddresses;
    private final List<String> replicationInstancePrivateIpAddresses;
    private final List<String> replicationInstanceIpv6Addresses;
    private final Boolean publiclyAccessible;
    private final String secondaryAvailabilityZone;
    private final Instant freeUntil;
    private final String dnsNameServers;
    private final String networkType;

    private ReplicationInstance(BuilderImpl builder) {
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.replicationInstanceStatus = builder.replicationInstanceStatus;
        this.allocatedStorage = builder.allocatedStorage;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.availabilityZone = builder.availabilityZone;
        this.replicationSubnetGroup = builder.replicationSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.kmsKeyId = builder.kmsKeyId;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationInstancePublicIpAddress = builder.replicationInstancePublicIpAddress;
        this.replicationInstancePrivateIpAddress = builder.replicationInstancePrivateIpAddress;
        this.replicationInstancePublicIpAddresses = builder.replicationInstancePublicIpAddresses;
        this.replicationInstancePrivateIpAddresses = builder.replicationInstancePrivateIpAddresses;
        this.replicationInstanceIpv6Addresses = builder.replicationInstanceIpv6Addresses;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.freeUntil = builder.freeUntil;
        this.dnsNameServers = builder.dnsNameServers;
        this.networkType = builder.networkType;
    }

    public final String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public final String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public final String replicationInstanceStatus() {
        return this.replicationInstanceStatus;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final ReplicationSubnetGroup replicationSubnetGroup() {
        return this.replicationSubnetGroup;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final ReplicationPendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    @Deprecated
    public final String replicationInstancePublicIpAddress() {
        return this.replicationInstancePublicIpAddress;
    }

    @Deprecated
    public final String replicationInstancePrivateIpAddress() {
        return this.replicationInstancePrivateIpAddress;
    }

    public final boolean hasReplicationInstancePublicIpAddresses() {
        return this.replicationInstancePublicIpAddresses != null && !(this.replicationInstancePublicIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replicationInstancePublicIpAddresses() {
        return this.replicationInstancePublicIpAddresses;
    }

    public final boolean hasReplicationInstancePrivateIpAddresses() {
        return this.replicationInstancePrivateIpAddresses != null && !(this.replicationInstancePrivateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replicationInstancePrivateIpAddresses() {
        return this.replicationInstancePrivateIpAddresses;
    }

    public final boolean hasReplicationInstanceIpv6Addresses() {
        return this.replicationInstanceIpv6Addresses != null && !(this.replicationInstanceIpv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> replicationInstanceIpv6Addresses() {
        return this.replicationInstanceIpv6Addresses;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String secondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public final Instant freeUntil() {
        return this.freeUntil;
    }

    public final String dnsNameServers() {
        return this.dnsNameServers;
    }

    public final String networkType() {
        return this.networkType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstancePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstancePrivateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInstancePublicIpAddresses() ? this.replicationInstancePublicIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInstancePrivateIpAddresses() ? this.replicationInstancePrivateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInstanceIpv6Addresses() ? this.replicationInstanceIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsNameServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInstance)) {
            return false;
        }
        ReplicationInstance other = (ReplicationInstance)obj;
        return Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.replicationInstanceStatus(), other.replicationInstanceStatus()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.replicationSubnetGroup(), other.replicationSubnetGroup()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.replicationInstancePublicIpAddress(), other.replicationInstancePublicIpAddress()) && Objects.equals(this.replicationInstancePrivateIpAddress(), other.replicationInstancePrivateIpAddress()) && this.hasReplicationInstancePublicIpAddresses() == other.hasReplicationInstancePublicIpAddresses() && Objects.equals(this.replicationInstancePublicIpAddresses(), other.replicationInstancePublicIpAddresses()) && this.hasReplicationInstancePrivateIpAddresses() == other.hasReplicationInstancePrivateIpAddresses() && Objects.equals(this.replicationInstancePrivateIpAddresses(), other.replicationInstancePrivateIpAddresses()) && this.hasReplicationInstanceIpv6Addresses() == other.hasReplicationInstanceIpv6Addresses() && Objects.equals(this.replicationInstanceIpv6Addresses(), other.replicationInstanceIpv6Addresses()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.secondaryAvailabilityZone(), other.secondaryAvailabilityZone()) && Objects.equals(this.freeUntil(), other.freeUntil()) && Objects.equals(this.dnsNameServers(), other.dnsNameServers()) && Objects.equals(this.networkType(), other.networkType());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationInstance").add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("ReplicationInstanceStatus", (Object)this.replicationInstanceStatus()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("ReplicationSubnetGroup", (Object)this.replicationSubnetGroup()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("ReplicationInstancePublicIpAddress", (Object)this.replicationInstancePublicIpAddress()).add("ReplicationInstancePrivateIpAddress", (Object)this.replicationInstancePrivateIpAddress()).add("ReplicationInstancePublicIpAddresses", this.hasReplicationInstancePublicIpAddresses() ? this.replicationInstancePublicIpAddresses() : null).add("ReplicationInstancePrivateIpAddresses", this.hasReplicationInstancePrivateIpAddresses() ? this.replicationInstancePrivateIpAddresses() : null).add("ReplicationInstanceIpv6Addresses", this.hasReplicationInstanceIpv6Addresses() ? this.replicationInstanceIpv6Addresses() : null).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecondaryAvailabilityZone", (Object)this.secondaryAvailabilityZone()).add("FreeUntil", (Object)this.freeUntil()).add("DnsNameServers", (Object)this.dnsNameServers()).add("NetworkType", (Object)this.networkType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "ReplicationInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceStatus()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ReplicationSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroup()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "ReplicationInstancePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.replicationInstancePublicIpAddress()));
            }
            case "ReplicationInstancePrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.replicationInstancePrivateIpAddress()));
            }
            case "ReplicationInstancePublicIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.replicationInstancePublicIpAddresses()));
            }
            case "ReplicationInstancePrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.replicationInstancePrivateIpAddresses()));
            }
            case "ReplicationInstanceIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIpv6Addresses()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "SecondaryAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.secondaryAvailabilityZone()));
            }
            case "FreeUntil": {
                return Optional.ofNullable(clazz.cast(this.freeUntil()));
            }
            case "DnsNameServers": {
                return Optional.ofNullable(clazz.cast(this.dnsNameServers()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInstance, T> g) {
        return obj -> g.apply((ReplicationInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationInstanceIdentifier;
        private String replicationInstanceClass;
        private String replicationInstanceStatus;
        private Integer allocatedStorage;
        private Instant instanceCreateTime;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private ReplicationSubnetGroup replicationSubnetGroup;
        private String preferredMaintenanceWindow;
        private ReplicationPendingModifiedValues pendingModifiedValues;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private String kmsKeyId;
        private String replicationInstanceArn;
        private String replicationInstancePublicIpAddress;
        private String replicationInstancePrivateIpAddress;
        private List<String> replicationInstancePublicIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> replicationInstancePrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> replicationInstanceIpv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean publiclyAccessible;
        private String secondaryAvailabilityZone;
        private Instant freeUntil;
        private String dnsNameServers;
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInstance model) {
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.replicationInstanceStatus(model.replicationInstanceStatus);
            this.allocatedStorage(model.allocatedStorage);
            this.instanceCreateTime(model.instanceCreateTime);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.availabilityZone(model.availabilityZone);
            this.replicationSubnetGroup(model.replicationSubnetGroup);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.kmsKeyId(model.kmsKeyId);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.replicationInstancePublicIpAddress(model.replicationInstancePublicIpAddress);
            this.replicationInstancePrivateIpAddress(model.replicationInstancePrivateIpAddress);
            this.replicationInstancePublicIpAddresses(model.replicationInstancePublicIpAddresses);
            this.replicationInstancePrivateIpAddresses(model.replicationInstancePrivateIpAddresses);
            this.replicationInstanceIpv6Addresses(model.replicationInstanceIpv6Addresses);
            this.publiclyAccessible(model.publiclyAccessible);
            this.secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            this.freeUntil(model.freeUntil);
            this.dnsNameServers(model.dnsNameServers);
            this.networkType(model.networkType);
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final String getReplicationInstanceStatus() {
            return this.replicationInstanceStatus;
        }

        public final void setReplicationInstanceStatus(String replicationInstanceStatus) {
            this.replicationInstanceStatus = replicationInstanceStatus;
        }

        @Override
        public final Builder replicationInstanceStatus(String replicationInstanceStatus) {
            this.replicationInstanceStatus = replicationInstanceStatus;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final ReplicationSubnetGroup.Builder getReplicationSubnetGroup() {
            return this.replicationSubnetGroup != null ? this.replicationSubnetGroup.toBuilder() : null;
        }

        public final void setReplicationSubnetGroup(ReplicationSubnetGroup.BuilderImpl replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup != null ? replicationSubnetGroup.build() : null;
        }

        @Override
        public final Builder replicationSubnetGroup(ReplicationSubnetGroup replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final ReplicationPendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(ReplicationPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        @Deprecated
        public final String getReplicationInstancePublicIpAddress() {
            return this.replicationInstancePublicIpAddress;
        }

        @Deprecated
        public final void setReplicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
            this.replicationInstancePublicIpAddress = replicationInstancePublicIpAddress;
        }

        @Override
        @Deprecated
        public final Builder replicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
            this.replicationInstancePublicIpAddress = replicationInstancePublicIpAddress;
            return this;
        }

        @Deprecated
        public final String getReplicationInstancePrivateIpAddress() {
            return this.replicationInstancePrivateIpAddress;
        }

        @Deprecated
        public final void setReplicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
            this.replicationInstancePrivateIpAddress = replicationInstancePrivateIpAddress;
        }

        @Override
        @Deprecated
        public final Builder replicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
            this.replicationInstancePrivateIpAddress = replicationInstancePrivateIpAddress;
            return this;
        }

        public final Collection<String> getReplicationInstancePublicIpAddresses() {
            if (this.replicationInstancePublicIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationInstancePublicIpAddresses;
        }

        public final void setReplicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses = ReplicationInstancePublicIpAddressListCopier.copy(replicationInstancePublicIpAddresses);
        }

        @Override
        public final Builder replicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses = ReplicationInstancePublicIpAddressListCopier.copy(replicationInstancePublicIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstancePublicIpAddresses(String ... replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses(Arrays.asList(replicationInstancePublicIpAddresses));
            return this;
        }

        public final Collection<String> getReplicationInstancePrivateIpAddresses() {
            if (this.replicationInstancePrivateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationInstancePrivateIpAddresses;
        }

        public final void setReplicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses = ReplicationInstancePrivateIpAddressListCopier.copy(replicationInstancePrivateIpAddresses);
        }

        @Override
        public final Builder replicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses = ReplicationInstancePrivateIpAddressListCopier.copy(replicationInstancePrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstancePrivateIpAddresses(String ... replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses(Arrays.asList(replicationInstancePrivateIpAddresses));
            return this;
        }

        public final Collection<String> getReplicationInstanceIpv6Addresses() {
            if (this.replicationInstanceIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationInstanceIpv6Addresses;
        }

        public final void setReplicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses = ReplicationInstanceIpv6AddressListCopier.copy(replicationInstanceIpv6Addresses);
        }

        @Override
        public final Builder replicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses = ReplicationInstanceIpv6AddressListCopier.copy(replicationInstanceIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceIpv6Addresses(String ... replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses(Arrays.asList(replicationInstanceIpv6Addresses));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getSecondaryAvailabilityZone() {
            return this.secondaryAvailabilityZone;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final Instant getFreeUntil() {
            return this.freeUntil;
        }

        public final void setFreeUntil(Instant freeUntil) {
            this.freeUntil = freeUntil;
        }

        @Override
        public final Builder freeUntil(Instant freeUntil) {
            this.freeUntil = freeUntil;
            return this;
        }

        public final String getDnsNameServers() {
            return this.dnsNameServers;
        }

        public final void setDnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
        }

        @Override
        public final Builder dnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public ReplicationInstance build() {
            return new ReplicationInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationInstance> {
        public Builder replicationInstanceIdentifier(String var1);

        public Builder replicationInstanceClass(String var1);

        public Builder replicationInstanceStatus(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder instanceCreateTime(Instant var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder replicationSubnetGroup(ReplicationSubnetGroup var1);

        default public Builder replicationSubnetGroup(Consumer<ReplicationSubnetGroup.Builder> replicationSubnetGroup) {
            return this.replicationSubnetGroup((ReplicationSubnetGroup)((ReplicationSubnetGroup.Builder)ReplicationSubnetGroup.builder().applyMutation(replicationSubnetGroup)).build());
        }

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(ReplicationPendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<ReplicationPendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((ReplicationPendingModifiedValues)((ReplicationPendingModifiedValues.Builder)ReplicationPendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder replicationInstanceArn(String var1);

        @Deprecated
        public Builder replicationInstancePublicIpAddress(String var1);

        @Deprecated
        public Builder replicationInstancePrivateIpAddress(String var1);

        public Builder replicationInstancePublicIpAddresses(Collection<String> var1);

        public Builder replicationInstancePublicIpAddresses(String ... var1);

        public Builder replicationInstancePrivateIpAddresses(Collection<String> var1);

        public Builder replicationInstancePrivateIpAddresses(String ... var1);

        public Builder replicationInstanceIpv6Addresses(Collection<String> var1);

        public Builder replicationInstanceIpv6Addresses(String ... var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder secondaryAvailabilityZone(String var1);

        public Builder freeUntil(Instant var1);

        public Builder dnsNameServers(String var1);

        public Builder networkType(String var1);
    }
}

