/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OriginTypeValue {
    SOURCE("SOURCE"),
    TARGET("TARGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OriginTypeValue> VALUE_MAP;
    private final String value;

    private OriginTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OriginTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OriginTypeValue> knownValues() {
        EnumSet<OriginTypeValue> knownValues = EnumSet.allOf(OriginTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OriginTypeValue.class, OriginTypeValue::toString);
    }
}

