/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationTaskRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateReplicationTaskRequest.Builder, CreateReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskIdentifier").getter(getter(CreateReplicationTaskRequest::replicationTaskIdentifier))
            .setter(setter(Builder::replicationTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndpointArn").getter(getter(CreateReplicationTaskRequest::sourceEndpointArn))
            .setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEndpointArn").getter(getter(CreateReplicationTaskRequest::targetEndpointArn))
            .setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn").getter(getter(CreateReplicationTaskRequest::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationType").getter(getter(CreateReplicationTaskRequest::migrationTypeAsString))
            .setter(setter(Builder::migrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableMappings").getter(getter(CreateReplicationTaskRequest::tableMappings))
            .setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskSettings").getter(getter(CreateReplicationTaskRequest::replicationTaskSettings))
            .setter(setter(Builder::replicationTaskSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build())
            .build();

    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CdcStartTime").getter(getter(CreateReplicationTaskRequest::cdcStartTime))
            .setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()).build();

    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStartPosition").getter(getter(CreateReplicationTaskRequest::cdcStartPosition))
            .setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStopPosition").getter(getter(CreateReplicationTaskRequest::cdcStopPosition))
            .setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateReplicationTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskData").getter(getter(CreateReplicationTaskRequest::taskData)).setter(setter(Builder::taskData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskData").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(CreateReplicationTaskRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_TASK_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD,
            REPLICATION_INSTANCE_ARN_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD,
            CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD, TAGS_FIELD, TASK_DATA_FIELD,
            RESOURCE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationTaskIdentifier;

    private final String sourceEndpointArn;

    private final String targetEndpointArn;

    private final String replicationInstanceArn;

    private final String migrationType;

    private final String tableMappings;

    private final String replicationTaskSettings;

    private final Instant cdcStartTime;

    private final String cdcStartPosition;

    private final String cdcStopPosition;

    private final List<Tag> tags;

    private final String taskData;

    private final String resourceIdentifier;

    private CreateReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.tags = builder.tags;
        this.taskData = builder.taskData;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    /**
     * <p>
     * An identifier for the replication task.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1-255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An identifier for the replication task.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1-255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String replicationTaskIdentifier() {
        return replicationTaskIdentifier;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
     */
    public final String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
     */
    public final String targetEndpointArn() {
        return targetEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
     *         <code>full-load-and-cdc</code>
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(migrationType);
    }

    /**
     * <p>
     * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
     *         <code>full-load-and-cdc</code>
     * @see MigrationTypeValue
     */
    public final String migrationTypeAsString() {
        return migrationType;
    }

    /**
     * <p>
     * The table mappings for the task, in JSON format. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
     * Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return The table mappings for the task, in JSON format. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html"
     *         >Using Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i>
     */
    public final String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * Overall settings for the task, in JSON format. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying
     * Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return Overall settings for the task, in JSON format. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html"
     *         >Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service
     *         User Guide.</i>
     */
    public final String replicationTaskSettings() {
        return replicationTaskSettings;
    }

    /**
     * <p>
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition
     * to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     * </p>
     * 
     * @return Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
     *         CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public final Instant cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * The value can be in date, checkpoint, or LSN/SCN format.
     * </p>
     * <p>
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     * </p>
     * <p>
     * Checkpoint Example: --cdc-start-position
     * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     * </p>
     * <p>
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     * </p>
     * <note>
     * <p>
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be
     * created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra
     * connection attribute to the name of this logical replication slot. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     * >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
     * </p>
     * </note>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     *         CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         The value can be in date, checkpoint, or LSN/SCN format.
     *         </p>
     *         <p>
     *         Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *         </p>
     *         <p>
     *         Checkpoint Example: --cdc-start-position
     *         "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *         </p>
     *         <p>
     *         LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *         </p>
     *         <note>
     *         <p>
     *         When you use this task setting with a source PostgreSQL database, a logical replication slot should
     *         already be created and associated with the source endpoint. You can verify this by setting the
     *         <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     *         >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
     *         </p>
     */
    public final String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
     * commit time.
     * </p>
     * <p>
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     * </p>
     * <p>
     * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
     *         time or commit time.</p>
     *         <p>
     *         Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *         </p>
     *         <p>
     *         Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
     */
    public final String cdcStopPosition() {
        return cdcStopPosition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags to be assigned to the replication task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags to be assigned to the replication task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for
     * Task Settings</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return Supplemental information that the task requires to migrate the data for certain source and target
     *         endpoints. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental
     *         Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i>
     */
    public final String taskData() {
        return taskData;
    }

    /**
     * <p>
     * A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter that is
     * returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31 characters.
     * It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two
     * consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
     * value might result in the <code>EndpointArn</code> value
     * <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a
     * <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of
     * <code>EndpointArn</code>.
     * </p>
     * 
     * @return A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter
     *         that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to
     *         31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a
     *         hyphen or contain two consecutive hyphens, and can only begin with a letter, such as
     *         <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code> value
     *         <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a
     *         <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of
     *         <code>EndpointArn</code>.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskData());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationTaskRequest)) {
            return false;
        }
        CreateReplicationTaskRequest other = (CreateReplicationTaskRequest) obj;
        return Objects.equals(replicationTaskIdentifier(), other.replicationTaskIdentifier())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(migrationTypeAsString(), other.migrationTypeAsString())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationTaskSettings(), other.replicationTaskSettings())
                && Objects.equals(cdcStartTime(), other.cdcStartTime())
                && Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(taskData(), other.taskData())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationTaskRequest").add("ReplicationTaskIdentifier", replicationTaskIdentifier())
                .add("SourceEndpointArn", sourceEndpointArn()).add("TargetEndpointArn", targetEndpointArn())
                .add("ReplicationInstanceArn", replicationInstanceArn()).add("MigrationType", migrationTypeAsString())
                .add("TableMappings", tableMappings()).add("ReplicationTaskSettings", replicationTaskSettings())
                .add("CdcStartTime", cdcStartTime()).add("CdcStartPosition", cdcStartPosition())
                .add("CdcStopPosition", cdcStopPosition()).add("Tags", hasTags() ? tags() : null).add("TaskData", taskData())
                .add("ResourceIdentifier", resourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskIdentifier":
            return Optional.ofNullable(clazz.cast(replicationTaskIdentifier()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "MigrationType":
            return Optional.ofNullable(clazz.cast(migrationTypeAsString()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationTaskSettings":
            return Optional.ofNullable(clazz.cast(replicationTaskSettings()));
        case "CdcStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TaskData":
            return Optional.ofNullable(clazz.cast(taskData()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationTaskIdentifier", REPLICATION_TASK_IDENTIFIER_FIELD);
        map.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
        map.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
        map.put("ReplicationInstanceArn", REPLICATION_INSTANCE_ARN_FIELD);
        map.put("MigrationType", MIGRATION_TYPE_FIELD);
        map.put("TableMappings", TABLE_MAPPINGS_FIELD);
        map.put("ReplicationTaskSettings", REPLICATION_TASK_SETTINGS_FIELD);
        map.put("CdcStartTime", CDC_START_TIME_FIELD);
        map.put("CdcStartPosition", CDC_START_POSITION_FIELD);
        map.put("CdcStopPosition", CDC_STOP_POSITION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TaskData", TASK_DATA_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationTaskRequest, T> g) {
        return obj -> g.apply((CreateReplicationTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationTaskRequest> {
        /**
         * <p>
         * An identifier for the replication task.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1-255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationTaskIdentifier
         *        An identifier for the replication task.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1-255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIdentifier(String replicationTaskIdentifier);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
         * </p>
         * 
         * @param sourceEndpointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
         * </p>
         * 
         * @param targetEndpointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of a replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
         * </p>
         * 
         * @param migrationType
         *        The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
         *        <code>full-load-and-cdc</code>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(String migrationType);

        /**
         * <p>
         * The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
         * </p>
         * 
         * @param migrationType
         *        The migration type. Valid values: <code>full-load</code> | <code>cdc</code> |
         *        <code>full-load-and-cdc</code>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(MigrationTypeValue migrationType);

        /**
         * <p>
         * The table mappings for the task, in JSON format. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using
         * Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param tableMappings
         *        The table mappings for the task, in JSON format. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using
         *        Table Mapping to Specify Task Settings</a> in the <i>Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * Overall settings for the task, in JSON format. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html"
         * >Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User
         * Guide.</i>
         * </p>
         * 
         * @param replicationTaskSettings
         *        Overall settings for the task, in JSON format. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html"
         *        >Specifying Task Settings for Database Migration Service Tasks</a> in the <i>Database Migration
         *        Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskSettings(String replicationTaskSettings);

        /**
         * <p>
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         * CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
         * error.
         * </p>
         * <p>
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * </p>
         * 
         * @param cdcStartTime
         *        Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         *        CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in
         *        an error.</p>
         *        <p>
         *        Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(Instant cdcStartTime);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         * </p>
         * <p>
         * The value can be in date, checkpoint, or LSN/SCN format.
         * </p>
         * <p>
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         * </p>
         * <p>
         * Checkpoint Example: --cdc-start-position
         * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         * </p>
         * <p>
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         * </p>
         * <note>
         * <p>
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already
         * be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code>
         * extra connection attribute to the name of this logical replication slot. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         * >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
         * </p>
         * </note>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         *        CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
         *        error.</p>
         *        <p>
         *        The value can be in date, checkpoint, or LSN/SCN format.
         *        </p>
         *        <p>
         *        Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *        </p>
         *        <p>
         *        Checkpoint Example: --cdc-start-position
         *        "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *        </p>
         *        <p>
         *        LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *        </p>
         *        <note>
         *        <p>
         *        When you use this task setting with a source PostgreSQL database, a logical replication slot should
         *        already be created and associated with the source endpoint. You can verify this by setting the
         *        <code>slotName</code> extra connection attribute to the name of this logical replication slot. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         *        >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
         * commit time.
         * </p>
         * <p>
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         * </p>
         * <p>
         * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
         *        time or commit time.</p>
         *        <p>
         *        Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *        </p>
         *        <p>
         *        Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        /**
         * <p>
         * One or more tags to be assigned to the replication task.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to be assigned to the replication task.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to be assigned to the replication task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databasemigration.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data
         * for Task Settings</a> in the <i>Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param taskData
         *        Supplemental information that the task requires to migrate the data for certain source and target
         *        endpoints. For more information, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying
         *        Supplemental Data for Task Settings</a> in the <i>Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskData(String taskData);

        /**
         * <p>
         * A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response parameter
         * that is returned in the created <code>Endpoint</code> object. The value for this parameter can have up to 31
         * characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or
         * contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code>. For
         * example, this value might result in the <code>EndpointArn</code> value
         * <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a
         * <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of
         * <code>EndpointArn</code>.
         * </p>
         * 
         * @param resourceIdentifier
         *        A friendly name for the resource identifier at the end of the <code>EndpointArn</code> response
         *        parameter that is returned in the created <code>Endpoint</code> object. The value for this parameter
         *        can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it
         *        can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as
         *        <code>Example-App-ARN1</code>. For example, this value might result in the <code>EndpointArn</code>
         *        value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't specify a
         *        <code>ResourceIdentifier</code> value, DMS generates a default identifier value for the end of
         *        <code>EndpointArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskIdentifier;

        private String sourceEndpointArn;

        private String targetEndpointArn;

        private String replicationInstanceArn;

        private String migrationType;

        private String tableMappings;

        private String replicationTaskSettings;

        private Instant cdcStartTime;

        private String cdcStartPosition;

        private String cdcStopPosition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String taskData;

        private String resourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationTaskRequest model) {
            super(model);
            replicationTaskIdentifier(model.replicationTaskIdentifier);
            sourceEndpointArn(model.sourceEndpointArn);
            targetEndpointArn(model.targetEndpointArn);
            replicationInstanceArn(model.replicationInstanceArn);
            migrationType(model.migrationType);
            tableMappings(model.tableMappings);
            replicationTaskSettings(model.replicationTaskSettings);
            cdcStartTime(model.cdcStartTime);
            cdcStartPosition(model.cdcStartPosition);
            cdcStopPosition(model.cdcStopPosition);
            tags(model.tags);
            taskData(model.taskData);
            resourceIdentifier(model.resourceIdentifier);
        }

        public final String getReplicationTaskIdentifier() {
            return replicationTaskIdentifier;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final String getMigrationType() {
            return migrationType;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationTaskSettings() {
            return replicationTaskSettings;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final Instant getCdcStartTime() {
            return cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskData() {
            return taskData;
        }

        public final void setTaskData(String taskData) {
            this.taskData = taskData;
        }

        @Override
        public final Builder taskData(String taskData) {
            this.taskData = taskData;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationTaskRequest build() {
            return new CreateReplicationTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
