/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an inventory database instance for a Fleet Advisor collector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseInstanceSoftwareDetailsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseInstanceSoftwareDetailsResponse.Builder, DatabaseInstanceSoftwareDetailsResponse> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DatabaseInstanceSoftwareDetailsResponse::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DatabaseInstanceSoftwareDetailsResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineEdition").getter(getter(DatabaseInstanceSoftwareDetailsResponse::engineEdition))
            .setter(setter(Builder::engineEdition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineEdition").build()).build();

    private static final SdkField<String> SERVICE_PACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePack").getter(getter(DatabaseInstanceSoftwareDetailsResponse::servicePack))
            .setter(setter(Builder::servicePack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePack").build()).build();

    private static final SdkField<String> SUPPORT_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportLevel").getter(getter(DatabaseInstanceSoftwareDetailsResponse::supportLevel))
            .setter(setter(Builder::supportLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLevel").build()).build();

    private static final SdkField<Integer> OS_ARCHITECTURE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OsArchitecture").getter(getter(DatabaseInstanceSoftwareDetailsResponse::osArchitecture))
            .setter(setter(Builder::osArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsArchitecture").build()).build();

    private static final SdkField<String> TOOLTIP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tooltip")
            .getter(getter(DatabaseInstanceSoftwareDetailsResponse::tooltip)).setter(setter(Builder::tooltip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, ENGINE_EDITION_FIELD, SERVICE_PACK_FIELD, SUPPORT_LEVEL_FIELD, OS_ARCHITECTURE_FIELD,
            TOOLTIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String engineVersion;

    private final String engineEdition;

    private final String servicePack;

    private final String supportLevel;

    private final Integer osArchitecture;

    private final String tooltip;

    private DatabaseInstanceSoftwareDetailsResponse(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineEdition = builder.engineEdition;
        this.servicePack = builder.servicePack;
        this.supportLevel = builder.supportLevel;
        this.osArchitecture = builder.osArchitecture;
        this.tooltip = builder.tooltip;
    }

    /**
     * <p>
     * The database engine of a database in a Fleet Advisor collector inventory, for example
     * <code>Microsoft SQL Server</code>.
     * </p>
     * 
     * @return The database engine of a database in a Fleet Advisor collector inventory, for example
     *         <code>Microsoft SQL Server</code>.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The database engine version of a database in a Fleet Advisor collector inventory, for example <code>2019</code>.
     * </p>
     * 
     * @return The database engine version of a database in a Fleet Advisor collector inventory, for example
     *         <code>2019</code>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The database engine edition of a database in a Fleet Advisor collector inventory, for example
     * <code>Express</code>.
     * </p>
     * 
     * @return The database engine edition of a database in a Fleet Advisor collector inventory, for example
     *         <code>Express</code>.
     */
    public final String engineEdition() {
        return engineEdition;
    }

    /**
     * <p>
     * The service pack level of the database.
     * </p>
     * 
     * @return The service pack level of the database.
     */
    public final String servicePack() {
        return servicePack;
    }

    /**
     * <p>
     * The support level of the database, for example <code>Mainstream support</code>.
     * </p>
     * 
     * @return The support level of the database, for example <code>Mainstream support</code>.
     */
    public final String supportLevel() {
        return supportLevel;
    }

    /**
     * <p>
     * The operating system architecture of the database.
     * </p>
     * 
     * @return The operating system architecture of the database.
     */
    public final Integer osArchitecture() {
        return osArchitecture;
    }

    /**
     * <p>
     * Information about the database engine software, for example
     * <code>Mainstream support ends on November 14th, 2024</code>.
     * </p>
     * 
     * @return Information about the database engine software, for example
     *         <code>Mainstream support ends on November 14th, 2024</code>.
     */
    public final String tooltip() {
        return tooltip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineEdition());
        hashCode = 31 * hashCode + Objects.hashCode(servicePack());
        hashCode = 31 * hashCode + Objects.hashCode(supportLevel());
        hashCode = 31 * hashCode + Objects.hashCode(osArchitecture());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInstanceSoftwareDetailsResponse)) {
            return false;
        }
        DatabaseInstanceSoftwareDetailsResponse other = (DatabaseInstanceSoftwareDetailsResponse) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineEdition(), other.engineEdition()) && Objects.equals(servicePack(), other.servicePack())
                && Objects.equals(supportLevel(), other.supportLevel())
                && Objects.equals(osArchitecture(), other.osArchitecture()) && Objects.equals(tooltip(), other.tooltip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseInstanceSoftwareDetailsResponse").add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("EngineEdition", engineEdition()).add("ServicePack", servicePack())
                .add("SupportLevel", supportLevel()).add("OsArchitecture", osArchitecture()).add("Tooltip", tooltip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineEdition":
            return Optional.ofNullable(clazz.cast(engineEdition()));
        case "ServicePack":
            return Optional.ofNullable(clazz.cast(servicePack()));
        case "SupportLevel":
            return Optional.ofNullable(clazz.cast(supportLevel()));
        case "OsArchitecture":
            return Optional.ofNullable(clazz.cast(osArchitecture()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EngineEdition", ENGINE_EDITION_FIELD);
        map.put("ServicePack", SERVICE_PACK_FIELD);
        map.put("SupportLevel", SUPPORT_LEVEL_FIELD);
        map.put("OsArchitecture", OS_ARCHITECTURE_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseInstanceSoftwareDetailsResponse, T> g) {
        return obj -> g.apply((DatabaseInstanceSoftwareDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseInstanceSoftwareDetailsResponse> {
        /**
         * <p>
         * The database engine of a database in a Fleet Advisor collector inventory, for example
         * <code>Microsoft SQL Server</code>.
         * </p>
         * 
         * @param engine
         *        The database engine of a database in a Fleet Advisor collector inventory, for example
         *        <code>Microsoft SQL Server</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The database engine version of a database in a Fleet Advisor collector inventory, for example
         * <code>2019</code>.
         * </p>
         * 
         * @param engineVersion
         *        The database engine version of a database in a Fleet Advisor collector inventory, for example
         *        <code>2019</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The database engine edition of a database in a Fleet Advisor collector inventory, for example
         * <code>Express</code>.
         * </p>
         * 
         * @param engineEdition
         *        The database engine edition of a database in a Fleet Advisor collector inventory, for example
         *        <code>Express</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineEdition(String engineEdition);

        /**
         * <p>
         * The service pack level of the database.
         * </p>
         * 
         * @param servicePack
         *        The service pack level of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePack(String servicePack);

        /**
         * <p>
         * The support level of the database, for example <code>Mainstream support</code>.
         * </p>
         * 
         * @param supportLevel
         *        The support level of the database, for example <code>Mainstream support</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportLevel(String supportLevel);

        /**
         * <p>
         * The operating system architecture of the database.
         * </p>
         * 
         * @param osArchitecture
         *        The operating system architecture of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osArchitecture(Integer osArchitecture);

        /**
         * <p>
         * Information about the database engine software, for example
         * <code>Mainstream support ends on November 14th, 2024</code>.
         * </p>
         * 
         * @param tooltip
         *        Information about the database engine software, for example
         *        <code>Mainstream support ends on November 14th, 2024</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(String tooltip);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String engineEdition;

        private String servicePack;

        private String supportLevel;

        private Integer osArchitecture;

        private String tooltip;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseInstanceSoftwareDetailsResponse model) {
            engine(model.engine);
            engineVersion(model.engineVersion);
            engineEdition(model.engineEdition);
            servicePack(model.servicePack);
            supportLevel(model.supportLevel);
            osArchitecture(model.osArchitecture);
            tooltip(model.tooltip);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEngineEdition() {
            return engineEdition;
        }

        public final void setEngineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
        }

        @Override
        public final Builder engineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
            return this;
        }

        public final String getServicePack() {
            return servicePack;
        }

        public final void setServicePack(String servicePack) {
            this.servicePack = servicePack;
        }

        @Override
        public final Builder servicePack(String servicePack) {
            this.servicePack = servicePack;
            return this;
        }

        public final String getSupportLevel() {
            return supportLevel;
        }

        public final void setSupportLevel(String supportLevel) {
            this.supportLevel = supportLevel;
        }

        @Override
        public final Builder supportLevel(String supportLevel) {
            this.supportLevel = supportLevel;
            return this;
        }

        public final Integer getOsArchitecture() {
            return osArchitecture;
        }

        public final void setOsArchitecture(Integer osArchitecture) {
            this.osArchitecture = osArchitecture;
        }

        @Override
        public final Builder osArchitecture(Integer osArchitecture) {
            this.osArchitecture = osArchitecture;
            return this;
        }

        public final String getTooltip() {
            return tooltip;
        }

        public final void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public final Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        @Override
        public DatabaseInstanceSoftwareDetailsResponse build() {
            return new DatabaseInstanceSoftwareDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
