/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a database in a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseResponse.Builder, DatabaseResponse> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(DatabaseResponse::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DatabaseResponse::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(DatabaseResponse::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<Long> NUMBER_OF_SCHEMAS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfSchemas").getter(getter(DatabaseResponse::numberOfSchemas))
            .setter(setter(Builder::numberOfSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSchemas").build()).build();

    private static final SdkField<ServerShortInfoResponse> SERVER_FIELD = SdkField
            .<ServerShortInfoResponse> builder(MarshallingType.SDK_POJO).memberName("Server")
            .getter(getter(DatabaseResponse::server)).setter(setter(Builder::server))
            .constructor(ServerShortInfoResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Server").build()).build();

    private static final SdkField<DatabaseInstanceSoftwareDetailsResponse> SOFTWARE_DETAILS_FIELD = SdkField
            .<DatabaseInstanceSoftwareDetailsResponse> builder(MarshallingType.SDK_POJO).memberName("SoftwareDetails")
            .getter(getter(DatabaseResponse::softwareDetails)).setter(setter(Builder::softwareDetails))
            .constructor(DatabaseInstanceSoftwareDetailsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareDetails").build()).build();

    private static final SdkField<List<CollectorShortInfoResponse>> COLLECTORS_FIELD = SdkField
            .<List<CollectorShortInfoResponse>> builder(MarshallingType.LIST)
            .memberName("Collectors")
            .getter(getter(DatabaseResponse::collectors))
            .setter(setter(Builder::collectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollectorShortInfoResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollectorShortInfoResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD,
            DATABASE_NAME_FIELD, IP_ADDRESS_FIELD, NUMBER_OF_SCHEMAS_FIELD, SERVER_FIELD, SOFTWARE_DETAILS_FIELD,
            COLLECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseId;

    private final String databaseName;

    private final String ipAddress;

    private final Long numberOfSchemas;

    private final ServerShortInfoResponse server;

    private final DatabaseInstanceSoftwareDetailsResponse softwareDetails;

    private final List<CollectorShortInfoResponse> collectors;

    private DatabaseResponse(BuilderImpl builder) {
        this.databaseId = builder.databaseId;
        this.databaseName = builder.databaseName;
        this.ipAddress = builder.ipAddress;
        this.numberOfSchemas = builder.numberOfSchemas;
        this.server = builder.server;
        this.softwareDetails = builder.softwareDetails;
        this.collectors = builder.collectors;
    }

    /**
     * <p>
     * The ID of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a database in a Fleet Advisor collector inventory.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The name of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The name of a database in a Fleet Advisor collector inventory.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The IP address of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The IP address of a database in a Fleet Advisor collector inventory.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The number of schemas in a Fleet Advisor collector inventory database.
     * </p>
     * 
     * @return The number of schemas in a Fleet Advisor collector inventory database.
     */
    public final Long numberOfSchemas() {
        return numberOfSchemas;
    }

    /**
     * <p>
     * The server name of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The server name of a database in a Fleet Advisor collector inventory.
     */
    public final ServerShortInfoResponse server() {
        return server;
    }

    /**
     * <p>
     * The software details of a database in a Fleet Advisor collector inventory, such as database engine and version.
     * </p>
     * 
     * @return The software details of a database in a Fleet Advisor collector inventory, such as database engine and
     *         version.
     */
    public final DatabaseInstanceSoftwareDetailsResponse softwareDetails() {
        return softwareDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Collectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCollectors() {
        return collectors != null && !(collectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of collectors associated with the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectors} method.
     * </p>
     * 
     * @return A list of collectors associated with the database.
     */
    public final List<CollectorShortInfoResponse> collectors() {
        return collectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSchemas());
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(softwareDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectors() ? collectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseResponse)) {
            return false;
        }
        DatabaseResponse other = (DatabaseResponse) obj;
        return Objects.equals(databaseId(), other.databaseId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(numberOfSchemas(), other.numberOfSchemas())
                && Objects.equals(server(), other.server()) && Objects.equals(softwareDetails(), other.softwareDetails())
                && hasCollectors() == other.hasCollectors() && Objects.equals(collectors(), other.collectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseResponse").add("DatabaseId", databaseId()).add("DatabaseName", databaseName())
                .add("IpAddress", ipAddress()).add("NumberOfSchemas", numberOfSchemas()).add("Server", server())
                .add("SoftwareDetails", softwareDetails()).add("Collectors", hasCollectors() ? collectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "NumberOfSchemas":
            return Optional.ofNullable(clazz.cast(numberOfSchemas()));
        case "Server":
            return Optional.ofNullable(clazz.cast(server()));
        case "SoftwareDetails":
            return Optional.ofNullable(clazz.cast(softwareDetails()));
        case "Collectors":
            return Optional.ofNullable(clazz.cast(collectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("NumberOfSchemas", NUMBER_OF_SCHEMAS_FIELD);
        map.put("Server", SERVER_FIELD);
        map.put("SoftwareDetails", SOFTWARE_DETAILS_FIELD);
        map.put("Collectors", COLLECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseResponse, T> g) {
        return obj -> g.apply((DatabaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseResponse> {
        /**
         * <p>
         * The ID of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseId
         *        The ID of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The name of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseName
         *        The name of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The IP address of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The number of schemas in a Fleet Advisor collector inventory database.
         * </p>
         * 
         * @param numberOfSchemas
         *        The number of schemas in a Fleet Advisor collector inventory database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSchemas(Long numberOfSchemas);

        /**
         * <p>
         * The server name of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param server
         *        The server name of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(ServerShortInfoResponse server);

        /**
         * <p>
         * The server name of a database in a Fleet Advisor collector inventory.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerShortInfoResponse.Builder} avoiding
         * the need to create one manually via {@link ServerShortInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerShortInfoResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #server(ServerShortInfoResponse)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link ServerShortInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(ServerShortInfoResponse)
         */
        default Builder server(Consumer<ServerShortInfoResponse.Builder> server) {
            return server(ServerShortInfoResponse.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * The software details of a database in a Fleet Advisor collector inventory, such as database engine and
         * version.
         * </p>
         * 
         * @param softwareDetails
         *        The software details of a database in a Fleet Advisor collector inventory, such as database engine and
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareDetails(DatabaseInstanceSoftwareDetailsResponse softwareDetails);

        /**
         * <p>
         * The software details of a database in a Fleet Advisor collector inventory, such as database engine and
         * version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatabaseInstanceSoftwareDetailsResponse.Builder} avoiding the need to create one manually via
         * {@link DatabaseInstanceSoftwareDetailsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseInstanceSoftwareDetailsResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #softwareDetails(DatabaseInstanceSoftwareDetailsResponse)}.
         * 
         * @param softwareDetails
         *        a consumer that will call methods on {@link DatabaseInstanceSoftwareDetailsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareDetails(DatabaseInstanceSoftwareDetailsResponse)
         */
        default Builder softwareDetails(Consumer<DatabaseInstanceSoftwareDetailsResponse.Builder> softwareDetails) {
            return softwareDetails(DatabaseInstanceSoftwareDetailsResponse.builder().applyMutation(softwareDetails).build());
        }

        /**
         * <p>
         * A list of collectors associated with the database.
         * </p>
         * 
         * @param collectors
         *        A list of collectors associated with the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectors(Collection<CollectorShortInfoResponse> collectors);

        /**
         * <p>
         * A list of collectors associated with the database.
         * </p>
         * 
         * @param collectors
         *        A list of collectors associated with the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectors(CollectorShortInfoResponse... collectors);

        /**
         * <p>
         * A list of collectors associated with the database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse.Builder#build()} is
         * called immediately and its result is passed to {@link #collectors(List<CollectorShortInfoResponse>)}.
         * 
         * @param collectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectors(java.util.Collection<CollectorShortInfoResponse>)
         */
        Builder collectors(Consumer<CollectorShortInfoResponse.Builder>... collectors);
    }

    static final class BuilderImpl implements Builder {
        private String databaseId;

        private String databaseName;

        private String ipAddress;

        private Long numberOfSchemas;

        private ServerShortInfoResponse server;

        private DatabaseInstanceSoftwareDetailsResponse softwareDetails;

        private List<CollectorShortInfoResponse> collectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseResponse model) {
            databaseId(model.databaseId);
            databaseName(model.databaseName);
            ipAddress(model.ipAddress);
            numberOfSchemas(model.numberOfSchemas);
            server(model.server);
            softwareDetails(model.softwareDetails);
            collectors(model.collectors);
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Long getNumberOfSchemas() {
            return numberOfSchemas;
        }

        public final void setNumberOfSchemas(Long numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
        }

        @Override
        public final Builder numberOfSchemas(Long numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
            return this;
        }

        public final ServerShortInfoResponse.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        public final void setServer(ServerShortInfoResponse.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(ServerShortInfoResponse server) {
            this.server = server;
            return this;
        }

        public final DatabaseInstanceSoftwareDetailsResponse.Builder getSoftwareDetails() {
            return softwareDetails != null ? softwareDetails.toBuilder() : null;
        }

        public final void setSoftwareDetails(DatabaseInstanceSoftwareDetailsResponse.BuilderImpl softwareDetails) {
            this.softwareDetails = softwareDetails != null ? softwareDetails.build() : null;
        }

        @Override
        public final Builder softwareDetails(DatabaseInstanceSoftwareDetailsResponse softwareDetails) {
            this.softwareDetails = softwareDetails;
            return this;
        }

        public final List<CollectorShortInfoResponse.Builder> getCollectors() {
            List<CollectorShortInfoResponse.Builder> result = CollectorsListCopier.copyToBuilder(this.collectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectors(Collection<CollectorShortInfoResponse.BuilderImpl> collectors) {
            this.collectors = CollectorsListCopier.copyFromBuilder(collectors);
        }

        @Override
        public final Builder collectors(Collection<CollectorShortInfoResponse> collectors) {
            this.collectors = CollectorsListCopier.copy(collectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(CollectorShortInfoResponse... collectors) {
            collectors(Arrays.asList(collectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Consumer<CollectorShortInfoResponse.Builder>... collectors) {
            collectors(Stream.of(collectors).map(c -> CollectorShortInfoResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DatabaseResponse build() {
            return new DatabaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
