/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetAdvisorSchemasResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeFleetAdvisorSchemasResponse.Builder, DescribeFleetAdvisorSchemasResponse> {
    private static final SdkField<List<SchemaResponse>> FLEET_ADVISOR_SCHEMAS_FIELD = SdkField
            .<List<SchemaResponse>> builder(MarshallingType.LIST)
            .memberName("FleetAdvisorSchemas")
            .getter(getter(DescribeFleetAdvisorSchemasResponse::fleetAdvisorSchemas))
            .setter(setter(Builder::fleetAdvisorSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAdvisorSchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetAdvisorSchemasResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ADVISOR_SCHEMAS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SchemaResponse> fleetAdvisorSchemas;

    private final String nextToken;

    private DescribeFleetAdvisorSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAdvisorSchemas = builder.fleetAdvisorSchemas;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetAdvisorSchemas property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetAdvisorSchemas() {
        return fleetAdvisorSchemas != null && !(fleetAdvisorSchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of <code>SchemaResponse</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetAdvisorSchemas} method.
     * </p>
     * 
     * @return A collection of <code>SchemaResponse</code> objects.
     */
    public final List<SchemaResponse> fleetAdvisorSchemas() {
        return fleetAdvisorSchemas;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetAdvisorSchemas() ? fleetAdvisorSchemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorSchemasResponse)) {
            return false;
        }
        DescribeFleetAdvisorSchemasResponse other = (DescribeFleetAdvisorSchemasResponse) obj;
        return hasFleetAdvisorSchemas() == other.hasFleetAdvisorSchemas()
                && Objects.equals(fleetAdvisorSchemas(), other.fleetAdvisorSchemas())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetAdvisorSchemasResponse")
                .add("FleetAdvisorSchemas", hasFleetAdvisorSchemas() ? fleetAdvisorSchemas() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetAdvisorSchemas":
            return Optional.ofNullable(clazz.cast(fleetAdvisorSchemas()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetAdvisorSchemas", FLEET_ADVISOR_SCHEMAS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorSchemasResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorSchemasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetAdvisorSchemasResponse> {
        /**
         * <p>
         * A collection of <code>SchemaResponse</code> objects.
         * </p>
         * 
         * @param fleetAdvisorSchemas
         *        A collection of <code>SchemaResponse</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetAdvisorSchemas(Collection<SchemaResponse> fleetAdvisorSchemas);

        /**
         * <p>
         * A collection of <code>SchemaResponse</code> objects.
         * </p>
         * 
         * @param fleetAdvisorSchemas
         *        A collection of <code>SchemaResponse</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetAdvisorSchemas(SchemaResponse... fleetAdvisorSchemas);

        /**
         * <p>
         * A collection of <code>SchemaResponse</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.SchemaResponse.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.SchemaResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.SchemaResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #fleetAdvisorSchemas(List<SchemaResponse>)}.
         * 
         * @param fleetAdvisorSchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.SchemaResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetAdvisorSchemas(java.util.Collection<SchemaResponse>)
         */
        Builder fleetAdvisorSchemas(Consumer<SchemaResponse.Builder>... fleetAdvisorSchemas);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<SchemaResponse> fleetAdvisorSchemas = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorSchemasResponse model) {
            super(model);
            fleetAdvisorSchemas(model.fleetAdvisorSchemas);
            nextToken(model.nextToken);
        }

        public final List<SchemaResponse.Builder> getFleetAdvisorSchemas() {
            List<SchemaResponse.Builder> result = FleetAdvisorSchemaListCopier.copyToBuilder(this.fleetAdvisorSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetAdvisorSchemas(Collection<SchemaResponse.BuilderImpl> fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas = FleetAdvisorSchemaListCopier.copyFromBuilder(fleetAdvisorSchemas);
        }

        @Override
        public final Builder fleetAdvisorSchemas(Collection<SchemaResponse> fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas = FleetAdvisorSchemaListCopier.copy(fleetAdvisorSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAdvisorSchemas(SchemaResponse... fleetAdvisorSchemas) {
            fleetAdvisorSchemas(Arrays.asList(fleetAdvisorSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAdvisorSchemas(Consumer<SchemaResponse.Builder>... fleetAdvisorSchemas) {
            fleetAdvisorSchemas(Stream.of(fleetAdvisorSchemas).map(c -> SchemaResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorSchemasResponse build() {
            return new DescribeFleetAdvisorSchemasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
