/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides error information about a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorDetails implements SdkPojo, Serializable, ToCopyableBuilder<ErrorDetails.Builder, ErrorDetails> {
    private static final SdkField<DefaultErrorDetails> DEFAULT_ERROR_DETAILS_FIELD = SdkField
            .<DefaultErrorDetails> builder(MarshallingType.SDK_POJO).memberName("defaultErrorDetails")
            .getter(getter(ErrorDetails::defaultErrorDetails)).setter(setter(Builder::defaultErrorDetails))
            .constructor(DefaultErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultErrorDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DefaultErrorDetails defaultErrorDetails;

    private final Type type;

    private ErrorDetails(BuilderImpl builder) {
        this.defaultErrorDetails = builder.defaultErrorDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * Error information about a project.
     * </p>
     * 
     * @return Error information about a project.
     */
    public final DefaultErrorDetails defaultErrorDetails() {
        return defaultErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultErrorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetails)) {
            return false;
        }
        ErrorDetails other = (ErrorDetails) obj;
        return Objects.equals(defaultErrorDetails(), other.defaultErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorDetails").add("DefaultErrorDetails", defaultErrorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultErrorDetails":
            return Optional.ofNullable(clazz.cast(defaultErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #defaultErrorDetails()} initialized to the given value.
     *
     * <p>
     * Error information about a project.
     * </p>
     * 
     * @param defaultErrorDetails
     *        Error information about a project.
     */
    public static ErrorDetails fromDefaultErrorDetails(DefaultErrorDetails defaultErrorDetails) {
        return builder().defaultErrorDetails(defaultErrorDetails).build();
    }

    /**
     * Create an instance of this class with {@link #defaultErrorDetails()} initialized to the given value.
     *
     * <p>
     * Error information about a project.
     * </p>
     * 
     * @param defaultErrorDetails
     *        Error information about a project.
     */
    public static ErrorDetails fromDefaultErrorDetails(Consumer<DefaultErrorDetails.Builder> defaultErrorDetails) {
        DefaultErrorDetails.Builder builder = DefaultErrorDetails.builder();
        defaultErrorDetails.accept(builder);
        return fromDefaultErrorDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultErrorDetails", DEFAULT_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetails, T> g) {
        return obj -> g.apply((ErrorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorDetails> {
        /**
         * <p>
         * Error information about a project.
         * </p>
         * 
         * @param defaultErrorDetails
         *        Error information about a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultErrorDetails(DefaultErrorDetails defaultErrorDetails);

        /**
         * <p>
         * Error information about a project.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultErrorDetails.Builder} avoiding the
         * need to create one manually via {@link DefaultErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultErrorDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultErrorDetails(DefaultErrorDetails)}.
         * 
         * @param defaultErrorDetails
         *        a consumer that will call methods on {@link DefaultErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultErrorDetails(DefaultErrorDetails)
         */
        default Builder defaultErrorDetails(Consumer<DefaultErrorDetails.Builder> defaultErrorDetails) {
            return defaultErrorDetails(DefaultErrorDetails.builder().applyMutation(defaultErrorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DefaultErrorDetails defaultErrorDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetails model) {
            defaultErrorDetails(model.defaultErrorDetails);
        }

        public final DefaultErrorDetails.Builder getDefaultErrorDetails() {
            return defaultErrorDetails != null ? defaultErrorDetails.toBuilder() : null;
        }

        public final void setDefaultErrorDetails(DefaultErrorDetails.BuilderImpl defaultErrorDetails) {
            Object oldValue = this.defaultErrorDetails;
            this.defaultErrorDetails = defaultErrorDetails != null ? defaultErrorDetails.build() : null;
            handleUnionValueChange(Type.DEFAULT_ERROR_DETAILS, oldValue, this.defaultErrorDetails);
        }

        @Override
        public final Builder defaultErrorDetails(DefaultErrorDetails defaultErrorDetails) {
            Object oldValue = this.defaultErrorDetails;
            this.defaultErrorDetails = defaultErrorDetails;
            handleUnionValueChange(Type.DEFAULT_ERROR_DETAILS, oldValue, this.defaultErrorDetails);
            return this;
        }

        @Override
        public ErrorDetails build() {
            return new ErrorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ErrorDetails#type()
     */
    public enum Type {
        DEFAULT_ERROR_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
