/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a schema object in a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetAdvisorSchemaObjectResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetAdvisorSchemaObjectResponse.Builder, FleetAdvisorSchemaObjectResponse> {
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaId").getter(getter(FleetAdvisorSchemaObjectResponse::schemaId)).setter(setter(Builder::schemaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectType").getter(getter(FleetAdvisorSchemaObjectResponse::objectType))
            .setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()).build();

    private static final SdkField<Long> NUMBER_OF_OBJECTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfObjects").getter(getter(FleetAdvisorSchemaObjectResponse::numberOfObjects))
            .setter(setter(Builder::numberOfObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfObjects").build()).build();

    private static final SdkField<Long> CODE_LINE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CodeLineCount").getter(getter(FleetAdvisorSchemaObjectResponse::codeLineCount))
            .setter(setter(Builder::codeLineCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeLineCount").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CodeSize")
            .getter(getter(FleetAdvisorSchemaObjectResponse::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            OBJECT_TYPE_FIELD, NUMBER_OF_OBJECTS_FIELD, CODE_LINE_COUNT_FIELD, CODE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaId;

    private final String objectType;

    private final Long numberOfObjects;

    private final Long codeLineCount;

    private final Long codeSize;

    private FleetAdvisorSchemaObjectResponse(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.objectType = builder.objectType;
        this.numberOfObjects = builder.numberOfObjects;
        this.codeLineCount = builder.codeLineCount;
        this.codeSize = builder.codeSize;
    }

    /**
     * <p>
     * The ID of a schema object in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a schema object in a Fleet Advisor collector inventory.
     */
    public final String schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The type of the schema object, as reported by the database engine. Examples include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>function</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>trigger</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM_TABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>QUEUE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of the schema object, as reported by the database engine. Examples include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>function</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>trigger</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM_TABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>QUEUE</code>
     *         </p>
     *         </li>
     */
    public final String objectType() {
        return objectType;
    }

    /**
     * <p>
     * The number of objects in a schema object in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The number of objects in a schema object in a Fleet Advisor collector inventory.
     */
    public final Long numberOfObjects() {
        return numberOfObjects;
    }

    /**
     * <p>
     * The number of lines of code in a schema object in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The number of lines of code in a schema object in a Fleet Advisor collector inventory.
     */
    public final Long codeLineCount() {
        return codeLineCount;
    }

    /**
     * <p>
     * The size level of the code in a schema object in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The size level of the code in a schema object in a Fleet Advisor collector inventory.
     */
    public final Long codeSize() {
        return codeSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(objectType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfObjects());
        hashCode = 31 * hashCode + Objects.hashCode(codeLineCount());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetAdvisorSchemaObjectResponse)) {
            return false;
        }
        FleetAdvisorSchemaObjectResponse other = (FleetAdvisorSchemaObjectResponse) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(objectType(), other.objectType())
                && Objects.equals(numberOfObjects(), other.numberOfObjects())
                && Objects.equals(codeLineCount(), other.codeLineCount()) && Objects.equals(codeSize(), other.codeSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetAdvisorSchemaObjectResponse").add("SchemaId", schemaId()).add("ObjectType", objectType())
                .add("NumberOfObjects", numberOfObjects()).add("CodeLineCount", codeLineCount()).add("CodeSize", codeSize())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "ObjectType":
            return Optional.ofNullable(clazz.cast(objectType()));
        case "NumberOfObjects":
            return Optional.ofNullable(clazz.cast(numberOfObjects()));
        case "CodeLineCount":
            return Optional.ofNullable(clazz.cast(codeLineCount()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("ObjectType", OBJECT_TYPE_FIELD);
        map.put("NumberOfObjects", NUMBER_OF_OBJECTS_FIELD);
        map.put("CodeLineCount", CODE_LINE_COUNT_FIELD);
        map.put("CodeSize", CODE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetAdvisorSchemaObjectResponse, T> g) {
        return obj -> g.apply((FleetAdvisorSchemaObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetAdvisorSchemaObjectResponse> {
        /**
         * <p>
         * The ID of a schema object in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param schemaId
         *        The ID of a schema object in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(String schemaId);

        /**
         * <p>
         * The type of the schema object, as reported by the database engine. Examples include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>function</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>trigger</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM_TABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>QUEUE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectType
         *        The type of the schema object, as reported by the database engine. Examples include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>function</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>trigger</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM_TABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>QUEUE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * The number of objects in a schema object in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param numberOfObjects
         *        The number of objects in a schema object in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfObjects(Long numberOfObjects);

        /**
         * <p>
         * The number of lines of code in a schema object in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param codeLineCount
         *        The number of lines of code in a schema object in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeLineCount(Long codeLineCount);

        /**
         * <p>
         * The size level of the code in a schema object in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param codeSize
         *        The size level of the code in a schema object in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);
    }

    static final class BuilderImpl implements Builder {
        private String schemaId;

        private String objectType;

        private Long numberOfObjects;

        private Long codeLineCount;

        private Long codeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetAdvisorSchemaObjectResponse model) {
            schemaId(model.schemaId);
            objectType(model.objectType);
            numberOfObjects(model.numberOfObjects);
            codeLineCount(model.codeLineCount);
            codeSize(model.codeSize);
        }

        public final String getSchemaId() {
            return schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getObjectType() {
            return objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public final Long getNumberOfObjects() {
            return numberOfObjects;
        }

        public final void setNumberOfObjects(Long numberOfObjects) {
            this.numberOfObjects = numberOfObjects;
        }

        @Override
        public final Builder numberOfObjects(Long numberOfObjects) {
            this.numberOfObjects = numberOfObjects;
            return this;
        }

        public final Long getCodeLineCount() {
            return codeLineCount;
        }

        public final void setCodeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
        }

        @Override
        public final Builder codeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
            return this;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        @Override
        public FleetAdvisorSchemaObjectResponse build() {
            return new FleetAdvisorSchemaObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
