/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an instance profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceProfile implements SdkPojo, Serializable, ToCopyableBuilder<InstanceProfile.Builder, InstanceProfile> {
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileArn").getter(getter(InstanceProfile::instanceProfileArn))
            .setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(InstanceProfile::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(InstanceProfile::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(InstanceProfile::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(InstanceProfile::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileName").getter(getter(InstanceProfile::instanceProfileName))
            .setter(setter(Builder::instanceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(InstanceProfile::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> INSTANCE_PROFILE_CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("InstanceProfileCreationTime")
            .getter(getter(InstanceProfile::instanceProfileCreationTime))
            .setter(setter(Builder::instanceProfileCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileCreationTime")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SUBNET_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupIdentifier").getter(getter(InstanceProfile::subnetGroupIdentifier))
            .setter(setter(Builder::subnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupIdentifier").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(InstanceProfile::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PROFILE_ARN_FIELD,
            AVAILABILITY_ZONE_FIELD, KMS_KEY_ARN_FIELD, PUBLICLY_ACCESSIBLE_FIELD, NETWORK_TYPE_FIELD,
            INSTANCE_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, INSTANCE_PROFILE_CREATION_TIME_FIELD, SUBNET_GROUP_IDENTIFIER_FIELD,
            VPC_SECURITY_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceProfileArn;

    private final String availabilityZone;

    private final String kmsKeyArn;

    private final Boolean publiclyAccessible;

    private final String networkType;

    private final String instanceProfileName;

    private final String description;

    private final Instant instanceProfileCreationTime;

    private final String subnetGroupIdentifier;

    private final List<String> vpcSecurityGroups;

    private InstanceProfile(BuilderImpl builder) {
        this.instanceProfileArn = builder.instanceProfileArn;
        this.availabilityZone = builder.availabilityZone;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.networkType = builder.networkType;
        this.instanceProfileName = builder.instanceProfileName;
        this.description = builder.description;
        this.instanceProfileCreationTime = builder.instanceProfileCreationTime;
        this.subnetGroupIdentifier = builder.subnetGroupIdentifier;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
     */
    public final String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The Availability Zone where the instance profile runs.
     * </p>
     * 
     * @return The Availability Zone where the instance profile runs.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for the instance
     * profile.
     * </p>
     * <p>
     * If you don't specify a value for the <code>KmsKeyArn</code> parameter, then DMS uses your default encryption key.
     * </p>
     * <p>
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has
     * a different default encryption key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for the
     *         instance profile.</p>
     *         <p>
     *         If you don't specify a value for the <code>KmsKeyArn</code> parameter, then DMS uses your default
     *         encryption key.
     *         </p>
     *         <p>
     *         KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
     *         account has a different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Specifies the accessibility options for the instance profile. A value of <code>true</code> represents an instance
     * profile with a public IP address. A value of <code>false</code> represents an instance profile with a private IP
     * address. The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies the accessibility options for the instance profile. A value of <code>true</code> represents an
     *         instance profile with a public IP address. A value of <code>false</code> represents an instance profile
     *         with a private IP address. The default value is <code>true</code>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Specifies the network type for the instance profile. A value of <code>IPV4</code> represents an instance profile
     * with IPv4 network type and only supports IPv4 addressing. A value of <code>IPV6</code> represents an instance
     * profile with IPv6 network type and only supports IPv6 addressing. A value of <code>DUAL</code> represents an
     * instance profile with dual network type that supports IPv4 and IPv6 addressing.
     * </p>
     * 
     * @return Specifies the network type for the instance profile. A value of <code>IPV4</code> represents an instance
     *         profile with IPv4 network type and only supports IPv4 addressing. A value of <code>IPV6</code> represents
     *         an instance profile with IPv6 network type and only supports IPv6 addressing. A value of
     *         <code>DUAL</code> represents an instance profile with dual network type that supports IPv4 and IPv6
     *         addressing.
     */
    public final String networkType() {
        return networkType;
    }

    /**
     * <p>
     * The user-friendly name for the instance profile.
     * </p>
     * 
     * @return The user-friendly name for the instance profile.
     */
    public final String instanceProfileName() {
        return instanceProfileName;
    }

    /**
     * <p>
     * A description of the instance profile. Descriptions can have up to 31 characters. A description can contain only
     * ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
     * and can only begin with a letter.
     * </p>
     * 
     * @return A description of the instance profile. Descriptions can have up to 31 characters. A description can
     *         contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two
     *         consecutive hyphens, and can only begin with a letter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time the instance profile was created.
     * </p>
     * 
     * @return The time the instance profile was created.
     */
    public final Instant instanceProfileCreationTime() {
        return instanceProfileCreationTime;
    }

    /**
     * <p>
     * The identifier of the subnet group that is associated with the instance profile.
     * </p>
     * 
     * @return The identifier of the subnet group that is associated with the instance profile.
     */
    public final String subnetGroupIdentifier() {
        return subnetGroupIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security groups that are used with the instance profile. The VPC security group must work with the VPC
     * containing the instance profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return The VPC security groups that are used with the instance profile. The VPC security group must work with
     *         the VPC containing the instance profile.
     */
    public final List<String> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile) obj;
        return Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(networkType(), other.networkType())
                && Objects.equals(instanceProfileName(), other.instanceProfileName())
                && Objects.equals(description(), other.description())
                && Objects.equals(instanceProfileCreationTime(), other.instanceProfileCreationTime())
                && Objects.equals(subnetGroupIdentifier(), other.subnetGroupIdentifier())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceProfile").add("InstanceProfileArn", instanceProfileArn())
                .add("AvailabilityZone", availabilityZone()).add("KmsKeyArn", kmsKeyArn())
                .add("PubliclyAccessible", publiclyAccessible()).add("NetworkType", networkType())
                .add("InstanceProfileName", instanceProfileName()).add("Description", description())
                .add("InstanceProfileCreationTime", instanceProfileCreationTime())
                .add("SubnetGroupIdentifier", subnetGroupIdentifier())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        case "InstanceProfileName":
            return Optional.ofNullable(clazz.cast(instanceProfileName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceProfileCreationTime":
            return Optional.ofNullable(clazz.cast(instanceProfileCreationTime()));
        case "SubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(subnetGroupIdentifier()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("InstanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InstanceProfileCreationTime", INSTANCE_PROFILE_CREATION_TIME_FIELD);
        map.put("SubnetGroupIdentifier", SUBNET_GROUP_IDENTIFIER_FIELD);
        map.put("VpcSecurityGroups", VPC_SECURITY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceProfile, T> g) {
        return obj -> g.apply((InstanceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceProfile> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
         * </p>
         * 
         * @param instanceProfileArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The Availability Zone where the instance profile runs.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the instance profile runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for the
         * instance profile.
         * </p>
         * <p>
         * If you don't specify a value for the <code>KmsKeyArn</code> parameter, then DMS uses your default encryption
         * key.
         * </p>
         * <p>
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for
         *        the instance profile.</p>
         *        <p>
         *        If you don't specify a value for the <code>KmsKeyArn</code> parameter, then DMS uses your default
         *        encryption key.
         *        </p>
         *        <p>
         *        KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Specifies the accessibility options for the instance profile. A value of <code>true</code> represents an
         * instance profile with a public IP address. A value of <code>false</code> represents an instance profile with
         * a private IP address. The default value is <code>true</code>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for the instance profile. A value of <code>true</code> represents
         *        an instance profile with a public IP address. A value of <code>false</code> represents an instance
         *        profile with a private IP address. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Specifies the network type for the instance profile. A value of <code>IPV4</code> represents an instance
         * profile with IPv4 network type and only supports IPv4 addressing. A value of <code>IPV6</code> represents an
         * instance profile with IPv6 network type and only supports IPv6 addressing. A value of <code>DUAL</code>
         * represents an instance profile with dual network type that supports IPv4 and IPv6 addressing.
         * </p>
         * 
         * @param networkType
         *        Specifies the network type for the instance profile. A value of <code>IPV4</code> represents an
         *        instance profile with IPv4 network type and only supports IPv4 addressing. A value of
         *        <code>IPV6</code> represents an instance profile with IPv6 network type and only supports IPv6
         *        addressing. A value of <code>DUAL</code> represents an instance profile with dual network type that
         *        supports IPv4 and IPv6 addressing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The user-friendly name for the instance profile.
         * </p>
         * 
         * @param instanceProfileName
         *        The user-friendly name for the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileName(String instanceProfileName);

        /**
         * <p>
         * A description of the instance profile. Descriptions can have up to 31 characters. A description can contain
         * only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive
         * hyphens, and can only begin with a letter.
         * </p>
         * 
         * @param description
         *        A description of the instance profile. Descriptions can have up to 31 characters. A description can
         *        contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two
         *        consecutive hyphens, and can only begin with a letter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time the instance profile was created.
         * </p>
         * 
         * @param instanceProfileCreationTime
         *        The time the instance profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileCreationTime(Instant instanceProfileCreationTime);

        /**
         * <p>
         * The identifier of the subnet group that is associated with the instance profile.
         * </p>
         * 
         * @param subnetGroupIdentifier
         *        The identifier of the subnet group that is associated with the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupIdentifier(String subnetGroupIdentifier);

        /**
         * <p>
         * The VPC security groups that are used with the instance profile. The VPC security group must work with the
         * VPC containing the instance profile.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The VPC security groups that are used with the instance profile. The VPC security group must work with
         *        the VPC containing the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<String> vpcSecurityGroups);

        /**
         * <p>
         * The VPC security groups that are used with the instance profile. The VPC security group must work with the
         * VPC containing the instance profile.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The VPC security groups that are used with the instance profile. The VPC security group must work with
         *        the VPC containing the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(String... vpcSecurityGroups);
    }

    static final class BuilderImpl implements Builder {
        private String instanceProfileArn;

        private String availabilityZone;

        private String kmsKeyArn;

        private Boolean publiclyAccessible;

        private String networkType;

        private String instanceProfileName;

        private String description;

        private Instant instanceProfileCreationTime;

        private String subnetGroupIdentifier;

        private List<String> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProfile model) {
            instanceProfileArn(model.instanceProfileArn);
            availabilityZone(model.availabilityZone);
            kmsKeyArn(model.kmsKeyArn);
            publiclyAccessible(model.publiclyAccessible);
            networkType(model.networkType);
            instanceProfileName(model.instanceProfileName);
            description(model.description);
            instanceProfileCreationTime(model.instanceProfileCreationTime);
            subnetGroupIdentifier(model.subnetGroupIdentifier);
            vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final String getInstanceProfileName() {
            return instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getInstanceProfileCreationTime() {
            return instanceProfileCreationTime;
        }

        public final void setInstanceProfileCreationTime(Instant instanceProfileCreationTime) {
            this.instanceProfileCreationTime = instanceProfileCreationTime;
        }

        @Override
        public final Builder instanceProfileCreationTime(Instant instanceProfileCreationTime) {
            this.instanceProfileCreationTime = instanceProfileCreationTime;
            return this;
        }

        public final String getSubnetGroupIdentifier() {
            return subnetGroupIdentifier;
        }

        public final void setSubnetGroupIdentifier(String subnetGroupIdentifier) {
            this.subnetGroupIdentifier = subnetGroupIdentifier;
        }

        @Override
        public final Builder subnetGroupIdentifier(String subnetGroupIdentifier) {
            this.subnetGroupIdentifier = subnetGroupIdentifier;
            return this;
        }

        public final Collection<String> getVpcSecurityGroups() {
            if (vpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroups;
        }

        public final void setVpcSecurityGroups(Collection<String> vpcSecurityGroups) {
            this.vpcSecurityGroups = StringListCopier.copy(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<String> vpcSecurityGroups) {
            this.vpcSecurityGroups = StringListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(String... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        public InstanceProfile build() {
            return new InstanceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
